/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.sis.internal.util.AbstractMapEntry;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.PropertyMap;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.ValueExistencePolicy;

final class ValueMap
extends PropertyMap<Object> {
    final Object metadata;
    final ValueExistencePolicy valuePolicy;

    ValueMap(Object metadata, PropertyAccessor accessor, KeyNamePolicy keyPolicy, ValueExistencePolicy valuePolicy) {
        super(accessor, keyPolicy);
        this.metadata = metadata;
        this.valuePolicy = valuePolicy;
    }

    @Override
    public boolean isEmpty() {
        return this.accessor.count(this.metadata, this.valuePolicy, 0) == 0;
    }

    @Override
    public int size() {
        return this.accessor.count(this.metadata, this.valuePolicy, 1);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public Object get(Object key) {
        Object value;
        if (key instanceof String && !this.valuePolicy.isSkipped(value = this.accessor.get(this.accessor.indexOf((String)key, false), this.metadata))) {
            return value;
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        Object old = this.accessor.set(this.accessor.indexOf(key, true), this.metadata, value, 1);
        return this.valuePolicy.isSkipped(old) ? null : old;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        for (Map.Entry<String, ?> e : map.entrySet()) {
            this.accessor.set(this.accessor.indexOf(e.getKey(), true), this.metadata, e.getValue(), 0);
        }
    }

    @Override
    public Object remove(Object key) throws UnsupportedOperationException {
        Object old;
        if (key instanceof String && !this.valuePolicy.isSkipped(old = this.accessor.set(this.accessor.indexOf((String)key, false), this.metadata, null, 1))) {
            return old;
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new Entries();
        }
        return this.entrySet;
    }

    @Override
    final Iterator<Map.Entry<String, Object>> iterator() {
        return new Iter();
    }

    private final class Entries
    extends PropertyMap.Entries {
        Entries() {
        }

        @Override
        public boolean contains(Object object) {
            int index;
            Map.Entry entry;
            Object key;
            if (object instanceof Map.Entry && (key = (entry = (Map.Entry)object).getKey()) instanceof String && (index = ValueMap.this.accessor.indexOf((String)key, false)) >= 0) {
                return new Property(index).equals(entry);
            }
            return false;
        }
    }

    private final class Iter
    implements Iterator<Map.Entry<String, Object>> {
        private Property current;
        private Property next;

        Iter() {
            this.move(0);
        }

        private void move(int index) {
            int count = ValueMap.this.accessor.count();
            while (index < count) {
                if (!ValueMap.this.valuePolicy.isSkipped(ValueMap.this.accessor.get(index, ValueMap.this.metadata))) {
                    this.next = new Property(index);
                    return;
                }
                ++index;
            }
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<String, Object> next() {
            if (this.next != null) {
                this.current = this.next;
                this.move(this.next.index + 1);
                return this.current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            this.current.setValue((Object)null);
            this.current = null;
        }
    }

    final class Property
    extends AbstractMapEntry<String, Object> {
        final int index;

        Property(int index) {
            this.index = index;
        }

        @Override
        public String getKey() {
            return ValueMap.this.accessor.name(this.index, ValueMap.this.keyPolicy);
        }

        public Class<?> getValueType() {
            return ValueMap.this.accessor.type(this.index, TypeValuePolicy.PROPERTY_TYPE);
        }

        @Override
        public Object getValue() {
            Object value = ValueMap.this.accessor.get(this.index, ValueMap.this.metadata);
            return ValueMap.this.valuePolicy.isSkipped(value) ? null : value;
        }

        @Override
        public Object setValue(Object value) {
            return ValueMap.this.accessor.set(this.index, ValueMap.this.metadata, value, 1);
        }
    }
}

