/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.io.ObjectStreamException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.opengis.annotation.UML;

final class StandardImplementation
extends MetadataStandard {
    private static final long serialVersionUID = 855786625369724248L;
    private final String implementationPackage;
    private final String[] prefix;
    private final String[] acronyms;
    private final transient Map<Class<?>, Class<?>> implementations;

    StandardImplementation(String citation, String interfacePackage, String implementationPackage, String[] prefix, String[] acronyms, MetadataStandard[] dependencies) {
        super(citation, interfacePackage, dependencies);
        this.implementationPackage = implementationPackage;
        this.prefix = prefix;
        this.acronyms = acronyms;
        this.implementations = new IdentityHashMap();
    }

    @Override
    boolean isPendingAPI(Class<?> type) {
        return type.getName().startsWith(this.implementationPackage) && type.isAnnotationPresent(UML.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Class<? extends T> getImplementation(Class<T> type) {
        String classname;
        if (type != null && type.isInterface() && this.isSupported(classname = type.getName())) {
            Map<Class<?>, Class<?>> map = this.implementations;
            synchronized (map) {
                Class<?> candidate = this.implementations.get(type);
                if (candidate != null) {
                    return candidate != Void.TYPE ? candidate.asSubclass(type) : null;
                }
                StringBuilder buffer = new StringBuilder(this.implementationPackage).append(classname, this.interfacePackage.length(), classname.length());
                if (this.acronyms != null) {
                    for (int i = 0; i < this.acronyms.length; i += 2) {
                        String acronym = this.acronyms[i];
                        if (!CharSequences.endsWith(buffer, acronym, false)) continue;
                        buffer.setLength(buffer.length() - acronym.length());
                        buffer.append(this.acronyms[i + 1]);
                        break;
                    }
                }
                int prefixPosition = buffer.lastIndexOf(".") + 1;
                int length = 0;
                for (String p : this.prefix) {
                    classname = buffer.replace(prefixPosition, prefixPosition + length, p).toString();
                    try {
                        candidate = Class.forName(classname);
                    }
                    catch (ClassNotFoundException e) {
                        Logging.recoverableException(Logging.getLogger("org.apache.sis.metadata"), MetadataStandard.class, "getImplementation", e);
                        length = p.length();
                        continue;
                    }
                    this.implementations.put(type, candidate);
                    return candidate.asSubclass(type);
                }
                this.implementations.put(type, Void.TYPE);
            }
        }
        return null;
    }

    Object readResolve() throws ObjectStreamException {
        if (StandardImplementation.ISO_19111.citation.equals(this.citation)) {
            return ISO_19111;
        }
        if (StandardImplementation.ISO_19115.citation.equals(this.citation)) {
            return ISO_19115;
        }
        StandardImplementation.setMapForField(StandardImplementation.class, this, "implementations");
        return this;
    }
}

