/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.IntSupplier;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.resources.Errors;

abstract class ArrayVector<E extends Number>
extends Vector
implements CheckedContainer<E>,
Serializable {
    private static final long serialVersionUID = 3496467575389288163L;

    ArrayVector() {
    }

    static Vector newInstance(Object array, boolean isUnsigned) throws IllegalArgumentException {
        ArrayVector vec;
        if (array instanceof double[]) {
            vec = new Doubles((double[])array);
        } else if (array instanceof float[]) {
            vec = new Floats((float[])array);
        } else if (array instanceof long[]) {
            vec = isUnsigned ? new UnsignedLongs((long[])array) : new Longs((long[])array);
        } else if (array instanceof int[]) {
            vec = isUnsigned ? new UnsignedIntegers((int[])array) : new Integers((int[])array);
        } else if (array instanceof short[]) {
            vec = isUnsigned ? new UnsignedShorts((short[])array) : new Shorts((short[])array);
        } else if (array instanceof byte[]) {
            vec = isUnsigned ? new UnsignedBytes((byte[])array) : new Bytes((byte[])array);
        } else if (array instanceof Number[]) {
            vec = new Raw((Number[])array);
        } else if (array instanceof String[]) {
            vec = new ASCII((String[])array);
        } else {
            throw new IllegalArgumentException(Errors.format((short)42, "array", Classes.getClass(array)));
        }
        return vec;
    }

    static Vector compress(Vector source, long min, long max) {
        boolean isSigned;
        boolean bl = isSigned = min >= -128L && max <= 127L;
        if (isSigned || min >= 0L && max <= 255L) {
            if (source instanceof Bytes) {
                return null;
            }
            byte[] array = new byte[source.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (byte)source.intValue(i);
            }
            return isSigned ? new Bytes(array) : new UnsignedBytes(array);
        }
        boolean bl2 = isSigned = min >= -32768L && max <= 32767L;
        if (isSigned || min >= 0L && max <= 65535L) {
            if (source instanceof Shorts) {
                return null;
            }
            short[] array = new short[source.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (short)source.intValue(i);
            }
            return isSigned ? new Shorts(array) : new UnsignedShorts(array);
        }
        boolean bl3 = isSigned = min >= Integer.MIN_VALUE && max <= Integer.MAX_VALUE;
        if (isSigned || min >= 0L && max <= -1L) {
            if (source instanceof Integers) {
                return null;
            }
            int[] array = new int[source.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (int)source.longValue(i);
            }
            return isSigned ? new Integers(array) : new UnsignedIntegers(array);
        }
        if (!(source instanceof Longs || source instanceof Floats || source instanceof Doubles)) {
            long[] array = new long[source.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = source.longValue(i);
            }
            return new Longs(array);
        }
        return null;
    }

    static Vector compress(Vector source, double tolerance) {
        if (!Float.class.equals(source.getElementType())) {
            int n;
            double d;
            int n2;
            double v;
            double d2;
            int length = source.size();
            int i = 0;
            do {
                if (i >= length) {
                    return new Floats(source.floatValues());
                }
                n2 = i++;
            } while (!(Math.abs(d2 - (double)((float)(v = source.doubleValue(n2)))) > tolerance));
            i = 0;
            do {
                if (i >= length) {
                    return new Decimal(source.floatValues());
                }
                n = i++;
            } while (!(Math.abs(d - DecimalFunctions.floatToDouble((float)(v = source.doubleValue(n)))) > tolerance));
        }
        return null;
    }

    @Override
    public boolean isNaN(int index) {
        return false;
    }

    void verifyType(Number value, byte expected) {
        Class<?> type = value.getClass();
        byte t = Numbers.getEnumConstant(type);
        if (t < 3 || t > expected) {
            throw new ClassCastException(Errors.format((short)7, type, Numbers.wrapperToPrimitive(this.getElementType())));
        }
    }

    private static final class Raw
    extends ArrayVector<Number> {
        private static final long serialVersionUID = 5444263017359778157L;
        private final Number[] array;

        Raw(Number[] array) {
            this.array = array;
        }

        @Override
        public final Class getElementType() {
            return this.array.getClass().getComponentType();
        }

        @Override
        public boolean isNaN(int index) {
            Number value = this.array[index];
            if (value == null) {
                return true;
            }
            if (value instanceof Float) {
                return ((Float)value).isNaN();
            }
            if (value instanceof Double) {
                return ((Double)value).isNaN();
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Number get(int index) {
            return this.array[index];
        }

        @Override
        public double doubleValue(int index) {
            return this.array[index].doubleValue();
        }

        @Override
        public float floatValue(int index) {
            return this.array[index].floatValue();
        }

        @Override
        public long longValue(int index) {
            return this.array[index].longValue();
        }

        @Override
        public int intValue(int index) {
            return this.array[index].intValue();
        }

        @Override
        public short shortValue(int index) {
            return this.array[index].shortValue();
        }

        @Override
        public byte byteValue(int index) {
            return this.array[index].byteValue();
        }

        @Override
        public String stringValue(int index) {
            Number value = this.array[index];
            return value != null ? value.toString() : null;
        }

        @Override
        public final Number set(int index, Number value) {
            Number old = this.array[index];
            this.array[index] = value;
            ++this.modCount;
            return old;
        }
    }

    private static final class ASCII
    extends ArrayVector<Double> {
        private static final long serialVersionUID = 2801615620517491573L;
        private final String[] array;

        ASCII(String[] array) {
            this.array = array;
        }

        @Override
        public final Class<Double> getElementType() {
            return Double.class;
        }

        @Override
        public boolean isNaN(int index) {
            String value = this.array[index];
            if (value == null) {
                return true;
            }
            if (value.contains("NaN")) {
                value = value.trim();
                switch (value.length()) {
                    case 3: {
                        return true;
                    }
                    case 4: {
                        char c = value.charAt(0);
                        return c == '+' || c == '-';
                    }
                }
            }
            return false;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public String stringValue(int index) {
            return this.array[index];
        }

        @Override
        public double doubleValue(int index) {
            return Double.parseDouble(this.array[index]);
        }

        @Override
        public float floatValue(int index) {
            return Float.parseFloat(this.array[index]);
        }

        @Override
        public long longValue(int index) {
            return Long.parseLong(this.array[index]);
        }

        @Override
        public int intValue(int index) {
            return Integer.parseInt(this.array[index]);
        }

        @Override
        public short shortValue(int index) {
            return Short.parseShort(this.array[index]);
        }

        @Override
        public byte byteValue(int index) {
            return Byte.parseByte(this.array[index]);
        }

        @Override
        public Number get(int index) {
            String value = this.array[index];
            return value != null ? Double.valueOf(Double.parseDouble(value)) : null;
        }

        @Override
        public final Number set(int index, Number value) {
            Number old = this.get(index);
            this.array[index] = value.toString();
            ++this.modCount;
            return old;
        }
    }

    private static final class UnsignedBytes
    extends Bytes {
        private static final long serialVersionUID = -2150064612523948331L;

        UnsignedBytes(byte[] array) {
            super(array);
        }

        @Override
        public boolean isUnsigned() {
            return true;
        }

        @Override
        public double doubleValue(int index) {
            return this.intValue(index);
        }

        @Override
        public float floatValue(int index) {
            return this.intValue(index);
        }

        @Override
        public long longValue(int index) {
            return Byte.toUnsignedLong(super.byteValue(index));
        }

        @Override
        public int intValue(int index) {
            return Byte.toUnsignedInt(super.byteValue(index));
        }

        @Override
        public short shortValue(int index) {
            return (short)this.intValue(index);
        }

        @Override
        public byte byteValue(int index) {
            byte value = super.byteValue(index);
            if (value >= 0) {
                return value;
            }
            throw new ArithmeticException(Errors.format((short)188, 8));
        }

        @Override
        public Number get(int index) {
            byte value = super.byteValue(index);
            if (value >= 0) {
                return value;
            }
            return (short)Byte.toUnsignedInt(value);
        }

        @Override
        void verifyType(Number value, byte expected) {
            int v = value.intValue();
            if ((v & 0xFFFFFF00) == 0) {
                expected = (byte)4;
            }
            super.verifyType(value, expected);
        }

        @Override
        public String stringValue(int index) {
            return Integer.toString(this.intValue(index));
        }

        @Override
        NumberRange<?> range(IntSupplier indices, int n) {
            short min = Short.MAX_VALUE;
            short max = Short.MIN_VALUE;
            while (--n >= 0) {
                short value = this.shortValue(indices != null ? indices.getAsInt() : n);
                if (value < min) {
                    min = value;
                }
                if (value <= max) continue;
                max = value;
            }
            return NumberRange.create(min, true, max, true);
        }
    }

    private static final class UnsignedShorts
    extends Shorts {
        private static final long serialVersionUID = 8219060080494444776L;

        UnsignedShorts(short[] array) {
            super(array);
        }

        @Override
        public boolean isUnsigned() {
            return true;
        }

        @Override
        public double doubleValue(int index) {
            return this.intValue(index);
        }

        @Override
        public float floatValue(int index) {
            return this.intValue(index);
        }

        @Override
        public long longValue(int index) {
            return Short.toUnsignedLong(super.shortValue(index));
        }

        @Override
        public int intValue(int index) {
            return Short.toUnsignedInt(super.shortValue(index));
        }

        @Override
        public short shortValue(int index) {
            short value = super.shortValue(index);
            if (value >= 0) {
                return value;
            }
            throw new ArithmeticException(Errors.format((short)188, 16));
        }

        @Override
        public Number get(int index) {
            short value = super.shortValue(index);
            if (value >= 0) {
                return value;
            }
            return Short.toUnsignedInt(value);
        }

        @Override
        void verifyType(Number value, byte expected) {
            int v = value.intValue();
            if ((v & 0xFFFF0000) == 0) {
                expected = (byte)5;
            }
            super.verifyType(value, expected);
        }

        @Override
        public String stringValue(int index) {
            return Integer.toString(this.intValue(index));
        }

        @Override
        NumberRange<?> range(IntSupplier indices, int n) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            while (--n >= 0) {
                int value = this.intValue(indices != null ? indices.getAsInt() : n);
                if (value < min) {
                    min = value;
                }
                if (value <= max) continue;
                max = value;
            }
            return NumberRange.create(min, true, max, true);
        }
    }

    private static final class UnsignedIntegers
    extends Integers {
        private static final long serialVersionUID = 8420585724189054050L;

        UnsignedIntegers(int[] array) {
            super(array);
        }

        @Override
        public boolean isUnsigned() {
            return true;
        }

        @Override
        public double doubleValue(int index) {
            return this.longValue(index);
        }

        @Override
        public float floatValue(int index) {
            return this.longValue(index);
        }

        @Override
        public long longValue(int index) {
            return Integer.toUnsignedLong(super.intValue(index));
        }

        @Override
        public int intValue(int index) {
            int value = super.intValue(index);
            if (value >= 0) {
                return value;
            }
            throw new ArithmeticException(Errors.format((short)188, 32));
        }

        @Override
        public Number get(int index) {
            int value = super.intValue(index);
            if (value >= 0) {
                return value;
            }
            return Integer.toUnsignedLong(value);
        }

        @Override
        void verifyType(Number value, byte expected) {
            long v = value.longValue();
            if ((v & 0xFFFFFFFF00000000L) == 0L) {
                expected = (byte)6;
            }
            super.verifyType(value, expected);
        }

        @Override
        public String stringValue(int index) {
            return Integer.toUnsignedString(super.intValue(index));
        }

        @Override
        NumberRange<?> range(IntSupplier indices, int n) {
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            while (--n >= 0) {
                long value = this.longValue(indices != null ? indices.getAsInt() : n);
                if (value < min) {
                    min = value;
                }
                if (value <= max) continue;
                max = value;
            }
            return NumberRange.create(min, true, max, true);
        }
    }

    private static final class UnsignedLongs
    extends Longs {
        private static final long serialVersionUID = 712968674526282882L;

        UnsignedLongs(long[] array) {
            super(array);
        }

        @Override
        public boolean isUnsigned() {
            return true;
        }

        @Override
        public double doubleValue(int index) {
            return Numerics.toUnsignedDouble(super.longValue(index));
        }

        @Override
        public float floatValue(int index) {
            return Numerics.toUnsignedFloat(super.longValue(index));
        }

        @Override
        public long longValue(int index) {
            long value = super.longValue(index);
            if (value >= 0L) {
                return value;
            }
            throw new ArithmeticException(Errors.format((short)188, 64));
        }

        @Override
        public String stringValue(int index) {
            return Long.toUnsignedString(super.longValue(index));
        }

        NumberRange<Double> range(IntSupplier indices, int n) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            while (--n >= 0) {
                double value = this.doubleValue(indices != null ? indices.getAsInt() : n);
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
            return NumberRange.create(min, true, max, true);
        }
    }

    private static class Bytes
    extends ArrayVector<Byte> {
        private static final long serialVersionUID = 7933568876180528548L;
        private final byte[] array;

        Bytes(byte[] array) {
            this.array = array;
        }

        @Override
        public final Class<Byte> getElementType() {
            return Byte.class;
        }

        @Override
        public final boolean isInteger() {
            return true;
        }

        @Override
        public String stringValue(int index) {
            return Byte.toString(this.array[index]);
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public double doubleValue(int index) {
            return this.array[index];
        }

        @Override
        public float floatValue(int index) {
            return this.array[index];
        }

        @Override
        public long longValue(int index) {
            return this.array[index];
        }

        @Override
        public int intValue(int index) {
            return this.array[index];
        }

        @Override
        public short shortValue(int index) {
            return this.array[index];
        }

        @Override
        public byte byteValue(int index) {
            return this.array[index];
        }

        @Override
        public Number get(int index) {
            return this.array[index];
        }

        @Override
        public final Number set(int index, Number value) {
            this.verifyType(value, (byte)3);
            Number old = this.get(index);
            this.array[index] = value.byteValue();
            ++this.modCount;
            return old;
        }

        @Override
        final int indexOf(int toSearch, int index, boolean equality) {
            byte first = this.array[toSearch];
            while (index < this.array.length && first == this.array[index] != equality) {
                ++index;
            }
            return index;
        }

        @Override
        final boolean equals(int lower, int upper, Vector other, int otherOffset) {
            if (other.getClass() == this.getClass()) {
                byte[] cmp = ((Bytes)other).array;
                while (lower < upper) {
                    if (this.array[lower++] == cmp[otherOffset++]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(lower, upper, other, otherOffset);
        }

        @Override
        NumberRange<?> range(IntSupplier indices, int n) {
            byte min = 127;
            byte max = -128;
            while (--n >= 0) {
                byte value = this.array[indices != null ? indices.getAsInt() : n];
                if (value < min) {
                    min = value;
                }
                if (value <= max) continue;
                max = value;
            }
            return NumberRange.create(min, true, max, true);
        }

        @Override
        public final Optional<Buffer> buffer() {
            return Optional.of(ByteBuffer.wrap(this.array));
        }

        @Override
        public final int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    private static class Shorts
    extends ArrayVector<Short> {
        private static final long serialVersionUID = -126825963332296000L;
        private final short[] array;

        Shorts(short[] array) {
            this.array = array;
        }

        @Override
        public final Class<Short> getElementType() {
            return Short.class;
        }

        @Override
        public final boolean isInteger() {
            return true;
        }

        @Override
        public String stringValue(int index) {
            return Short.toString(this.array[index]);
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public double doubleValue(int index) {
            return this.array[index];
        }

        @Override
        public float floatValue(int index) {
            return this.array[index];
        }

        @Override
        public long longValue(int index) {
            return this.array[index];
        }

        @Override
        public int intValue(int index) {
            return this.array[index];
        }

        @Override
        public short shortValue(int index) {
            return this.array[index];
        }

        @Override
        public Number get(int index) {
            return this.array[index];
        }

        @Override
        public final Number set(int index, Number value) {
            this.verifyType(value, (byte)4);
            Number old = this.get(index);
            this.array[index] = value.shortValue();
            ++this.modCount;
            return old;
        }

        @Override
        final int indexOf(int toSearch, int index, boolean equality) {
            short first = this.array[toSearch];
            while (index < this.array.length && first == this.array[index] != equality) {
                ++index;
            }
            return index;
        }

        @Override
        final boolean equals(int lower, int upper, Vector other, int otherOffset) {
            if (other.getClass() == this.getClass()) {
                short[] cmp = ((Shorts)other).array;
                while (lower < upper) {
                    if (this.array[lower++] == cmp[otherOffset++]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(lower, upper, other, otherOffset);
        }

        @Override
        NumberRange<?> range(IntSupplier indices, int n) {
            short min = Short.MAX_VALUE;
            short max = Short.MIN_VALUE;
            while (--n >= 0) {
                short value = this.array[indices != null ? indices.getAsInt() : n];
                if (value < min) {
                    min = value;
                }
                if (value <= max) continue;
                max = value;
            }
            return NumberRange.create(min, true, max, true);
        }

        @Override
        public final Optional<Buffer> buffer() {
            return Optional.of(ShortBuffer.wrap(this.array));
        }

        @Override
        public final int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    private static class Integers
    extends ArrayVector<Integer> {
        private static final long serialVersionUID = -1292641147544275801L;
        private final int[] array;

        Integers(int[] array) {
            this.array = array;
        }

        @Override
        public final Class<Integer> getElementType() {
            return Integer.class;
        }

        @Override
        public final boolean isInteger() {
            return true;
        }

        @Override
        public String stringValue(int index) {
            return Integer.toString(this.array[index]);
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public double doubleValue(int index) {
            return this.array[index];
        }

        @Override
        public float floatValue(int index) {
            return this.array[index];
        }

        @Override
        public long longValue(int index) {
            return this.array[index];
        }

        @Override
        public int intValue(int index) {
            return this.array[index];
        }

        @Override
        public Number get(int index) {
            return this.array[index];
        }

        @Override
        public final Number set(int index, Number value) {
            this.verifyType(value, (byte)5);
            Number old = this.get(index);
            this.array[index] = value.intValue();
            ++this.modCount;
            return old;
        }

        @Override
        final int indexOf(int toSearch, int index, boolean equality) {
            int first = this.array[toSearch];
            while (index < this.array.length && first == this.array[index] != equality) {
                ++index;
            }
            return index;
        }

        @Override
        final boolean equals(int lower, int upper, Vector other, int otherOffset) {
            if (other.getClass() == this.getClass()) {
                int[] cmp = ((Integers)other).array;
                while (lower < upper) {
                    if (this.array[lower++] == cmp[otherOffset++]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(lower, upper, other, otherOffset);
        }

        @Override
        NumberRange<?> range(IntSupplier indices, int n) {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            while (--n >= 0) {
                int value = this.array[indices != null ? indices.getAsInt() : n];
                if (value < min) {
                    min = value;
                }
                if (value <= max) continue;
                max = value;
            }
            return NumberRange.create(min, true, max, true);
        }

        @Override
        public final Number increment(double tolerance) {
            if (!(tolerance >= 0.0) || !(tolerance < 1.0)) {
                return super.increment(tolerance);
            }
            int i = this.array.length;
            if (i >= 2) {
                long inc;
                boolean isSigned;
                boolean bl = isSigned = (inc = this.longValue(--i) - this.longValue(--i)) >= Integer.MIN_VALUE && inc <= Integer.MAX_VALUE;
                if (isSigned || this.isUnsigned()) {
                    int asInt = (int)inc;
                    int p = this.array[i];
                    while (i != 0) {
                        if (p - (p = this.array[--i]) == asInt) continue;
                        return null;
                    }
                    if (isSigned) {
                        return asInt;
                    }
                    return inc;
                }
            }
            return null;
        }

        @Override
        public final Optional<Buffer> buffer() {
            return Optional.of(IntBuffer.wrap(this.array));
        }

        @Override
        public final int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    private static class Longs
    extends ArrayVector<Long> {
        private static final long serialVersionUID = 338413429037224587L;
        private final long[] array;

        Longs(long[] array) {
            this.array = array;
        }

        @Override
        public final Class<Long> getElementType() {
            return Long.class;
        }

        @Override
        public final boolean isInteger() {
            return true;
        }

        @Override
        public String stringValue(int index) {
            return Long.toString(this.array[index]);
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public double doubleValue(int index) {
            return this.array[index];
        }

        @Override
        public float floatValue(int index) {
            return this.array[index];
        }

        @Override
        public long longValue(int index) {
            return this.array[index];
        }

        @Override
        public final Number get(int index) {
            return this.longValue(index);
        }

        @Override
        public final Number set(int index, Number value) {
            this.verifyType(value, (byte)6);
            Number old = this.get(index);
            this.array[index] = value.longValue();
            ++this.modCount;
            return old;
        }

        @Override
        final int indexOf(int toSearch, int index, boolean equality) {
            long first = this.array[toSearch];
            while (index < this.array.length && first == this.array[index] != equality) {
                ++index;
            }
            return index;
        }

        @Override
        final boolean equals(int lower, int upper, Vector other, int otherOffset) {
            if (other.getClass() == this.getClass()) {
                long[] cmp = ((Longs)other).array;
                while (lower < upper) {
                    if (this.array[lower++] == cmp[otherOffset++]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(lower, upper, other, otherOffset);
        }

        @Override
        NumberRange<?> range(IntSupplier indices, int n) {
            long min = Long.MAX_VALUE;
            long max = Long.MIN_VALUE;
            while (--n >= 0) {
                long value = this.array[indices != null ? indices.getAsInt() : n];
                if (value < min) {
                    min = value;
                }
                if (value <= max) continue;
                max = value;
            }
            return NumberRange.create(min, true, max, true);
        }

        @Override
        public final Number increment(double tolerance) {
            if (!(tolerance >= 0.0) || !(tolerance < 1.0)) {
                return super.increment(tolerance);
            }
            int i = this.array.length;
            if (i >= 2) {
                long inc;
                long p;
                try {
                    long l = this.array[--i];
                    p = this.array[--i];
                    inc = this.subtract(l, p);
                }
                catch (ArithmeticException e) {
                    this.warning("increment", e);
                    return null;
                }
                while (i != 0) {
                    if (p - (p = this.array[--i]) == inc) continue;
                    return null;
                }
                return inc;
            }
            return null;
        }

        @Override
        public final Optional<Buffer> buffer() {
            return Optional.of(LongBuffer.wrap(this.array));
        }

        @Override
        public final int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    static final class Decimal
    extends Floats {
        private static final long serialVersionUID = 6085386820455858377L;

        Decimal(float[] array) {
            super(array);
        }

        @Override
        public double doubleValue(int index) {
            return DecimalFunctions.floatToDouble(super.floatValue(index));
        }

        @Override
        public Number get(int index) {
            return this.doubleValue(index);
        }

        @Override
        NumberRange<?> createRange(float min, float max) {
            return NumberRange.create(DecimalFunctions.floatToDouble(min), true, DecimalFunctions.floatToDouble(max), true);
        }

        @Override
        public int hashCode() {
            int hash = 1;
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                hash = 31 * hash + Double.hashCode(this.doubleValue(i));
            }
            return hash;
        }
    }

    private static class Floats
    extends ArrayVector<Float> {
        private static final long serialVersionUID = 5395284704294981455L;
        private final float[] array;

        Floats(float[] array) {
            this.array = array;
        }

        @Override
        public final Class<Float> getElementType() {
            return Float.class;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final boolean isNaN(int index) {
            return Float.isNaN(this.array[index]);
        }

        @Override
        public final String stringValue(int index) {
            return Float.toString(this.array[index]);
        }

        @Override
        public double doubleValue(int index) {
            return this.array[index];
        }

        @Override
        public final float floatValue(int index) {
            return this.array[index];
        }

        @Override
        public Number get(int index) {
            return Float.valueOf(this.array[index]);
        }

        @Override
        public final Number set(int index, Number value) {
            float old = this.array[index];
            this.array[index] = value.floatValue();
            ++this.modCount;
            return Float.valueOf(old);
        }

        @Override
        final int indexOf(int toSearch, int index, boolean equality) {
            int first = Float.floatToIntBits(this.array[toSearch]);
            while (index < this.array.length && first == Float.floatToIntBits(this.array[index]) != equality) {
                ++index;
            }
            return index;
        }

        @Override
        final boolean equals(int lower, int upper, Vector other, int otherOffset) {
            if (other.getClass() == this.getClass()) {
                float[] cmp = ((Floats)other).array;
                while (lower < upper) {
                    if (Float.floatToIntBits(this.array[lower++]) == Float.floatToIntBits(cmp[otherOffset++])) continue;
                    return false;
                }
                return true;
            }
            return super.equals(lower, upper, other, otherOffset);
        }

        @Override
        final NumberRange<?> range(IntSupplier indices, int n) {
            float min = Float.POSITIVE_INFINITY;
            float max = Float.NEGATIVE_INFINITY;
            while (--n >= 0) {
                float value = this.array[indices != null ? indices.getAsInt() : n];
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
            return this.createRange(min, max);
        }

        NumberRange<?> createRange(float min, float max) {
            return NumberRange.create(min, true, max, true);
        }

        @Override
        public final Optional<Buffer> buffer() {
            return Optional.of(FloatBuffer.wrap(this.array));
        }

        @Override
        public final float[] floatValues() {
            return (float[])this.array.clone();
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }

    static final class Doubles
    extends ArrayVector<Double> {
        private static final long serialVersionUID = -2900375382498345812L;
        private final double[] array;

        Doubles(double[] array) {
            this.array = array;
        }

        @Override
        public Class<Double> getElementType() {
            return Double.class;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public boolean isNaN(int index) {
            return Double.isNaN(this.array[index]);
        }

        @Override
        public String stringValue(int index) {
            return Double.toString(this.array[index]);
        }

        @Override
        public double doubleValue(int index) {
            return this.array[index];
        }

        @Override
        public float floatValue(int index) {
            return (float)this.array[index];
        }

        @Override
        public Number get(int index) {
            return this.array[index];
        }

        @Override
        public Number set(int index, Number value) {
            double old = this.array[index];
            this.array[index] = value.doubleValue();
            ++this.modCount;
            return old;
        }

        @Override
        int indexOf(int toSearch, int index, boolean equality) {
            long first = Double.doubleToLongBits(this.array[toSearch]);
            while (index < this.array.length && first == Double.doubleToLongBits(this.array[index]) != equality) {
                ++index;
            }
            return index;
        }

        @Override
        boolean equals(int lower, int upper, Vector other, int otherOffset) {
            if (other instanceof Doubles) {
                double[] cmp = ((Doubles)other).array;
                while (lower < upper) {
                    if (Double.doubleToLongBits(this.array[lower++]) == Double.doubleToLongBits(cmp[otherOffset++])) continue;
                    return false;
                }
                return true;
            }
            return super.equals(lower, upper, other, otherOffset);
        }

        NumberRange<Double> range(IntSupplier indices, int n) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            while (--n >= 0) {
                double value = this.array[indices != null ? indices.getAsInt() : n];
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
            return NumberRange.create(min, true, max, true);
        }

        @Override
        public Optional<Buffer> buffer() {
            return Optional.of(DoubleBuffer.wrap(this.array));
        }

        @Override
        public double[] doubleValues() {
            return (double[])this.array.clone();
        }

        @Override
        public float[] floatValues() {
            return ArraysExt.copyAsFloats(this.array);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.array);
        }
    }
}

