/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.Console;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.UnformattableObjectException;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.util.ArgumentChecks;

@XmlTransient
public abstract class FormattableObject {
    private static final AtomicReference<Formatter> FORMATTER = new AtomicReference();

    protected FormattableObject() {
    }

    public String toWKT() throws UnformattableObjectException {
        return this.formatWKT(Convention.DEFAULT, false, true);
    }

    public String toString() {
        return this.formatWKT(Convention.WKT2_SIMPLIFIED, false, false);
    }

    public String toString(Convention convention) {
        ArgumentChecks.ensureNonNull("convention", (Object)convention);
        return this.formatWKT(convention, false, false);
    }

    public void print() {
        Console console = System.console();
        PrintWriter out = console != null ? console.writer() : null;
        String wkt = this.formatWKT(Convention.WKT2_SIMPLIFIED, out != null && X364.isAnsiSupported(), false);
        if (out != null) {
            out.println(wkt);
        } else {
            System.out.println(wkt);
        }
    }

    private String formatWKT(Convention convention, boolean colorize, boolean strict) throws UnformattableObjectException {
        String wkt;
        Formatter formatter = FORMATTER.getAndSet(null);
        if (formatter == null) {
            formatter = new Formatter();
        }
        formatter.configure(convention, null, colorize ? Colors.DEFAULT : null, convention.toUpperCase ? (byte)1 : 0, convention.majorVersion() == 1 ? (byte)-1 : 0, (byte)2, strict ? Integer.MAX_VALUE : 10);
        if (!strict) {
            formatter.transliterator = Transliterator.IDENTITY;
        }
        formatter.verifyCharacterValidity = strict;
        try {
            Warnings warnings;
            formatter.append(this);
            if (strict && (warnings = formatter.getWarnings()) != null) {
                int n = warnings.getNumMessages() - 1;
                throw new UnformattableObjectException(warnings.getMessage(n), warnings.getException(n));
            }
            formatter.appendWarnings();
            wkt = formatter.toWKT();
        }
        catch (IOException e) {
            throw new UnformattableObjectException(e);
        }
        finally {
            formatter.clear();
        }
        FORMATTER.set(formatter);
        return wkt;
    }

    protected abstract String formatTo(Formatter var1);
}

