/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.xml;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.system.SystemListener;

public final class XmlUtilities
extends SystemListener {
    private static volatile DatatypeFactory factory;

    private XmlUtilities() {
        super("org.apache.sis.util");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void classpathChanged() {
        Class<XmlUtilities> clazz = XmlUtilities.class;
        synchronized (XmlUtilities.class) {
            factory = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatatypeFactory getDatatypeFactory() throws DatatypeConfigurationException {
        DatatypeFactory f = factory;
        if (f != null) return f;
        Class<XmlUtilities> clazz = XmlUtilities.class;
        synchronized (XmlUtilities.class) {
            f = factory;
            if (f != null) return f;
            factory = f = DatatypeFactory.newInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return f;
        }
    }

    public static boolean trimTime(XMLGregorianCalendar gc, boolean force) {
        if (force || gc.getMillisecond() == 0) {
            gc.setMillisecond(Integer.MIN_VALUE);
            if (force || gc.getHour() == 0 && gc.getMinute() == 0 && gc.getSecond() == 0) {
                gc.setHour(Integer.MIN_VALUE);
                gc.setMinute(Integer.MIN_VALUE);
                gc.setSecond(Integer.MIN_VALUE);
                gc.setTimezone(Integer.MIN_VALUE);
                return true;
            }
        }
        return false;
    }

    public static XMLGregorianCalendar toXML(Context context, Date date) throws DatatypeConfigurationException {
        if (date != null) {
            GregorianCalendar calendar = XmlUtilities.createGregorianCalendar(context);
            calendar.setTime(date);
            return XmlUtilities.getDatatypeFactory().newXMLGregorianCalendar(calendar);
        }
        return null;
    }

    private static GregorianCalendar createGregorianCalendar(Context context) {
        if (context != null) {
            Locale locale = context.getLocale();
            TimeZone timezone = context.getTimeZone();
            if (timezone != null) {
                return locale != null ? new GregorianCalendar(timezone, locale) : new GregorianCalendar(timezone);
            }
            if (locale != null) {
                return new GregorianCalendar(locale);
            }
        }
        return new GregorianCalendar();
    }

    public static Date toDate(Context context, XMLGregorianCalendar xml) {
        if (xml != null) {
            TimeZone timezone;
            GregorianCalendar calendar = xml.toGregorianCalendar();
            if (context != null && xml.getTimezone() == Integer.MIN_VALUE && (timezone = context.getTimeZone()) != null) {
                calendar.setTimeZone(timezone);
            }
            return calendar.getTime();
        }
        return null;
    }

    static {
        SystemListener.add(new XmlUtilities());
    }
}

