/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.lang.reflect.Array;
import java.util.Formatter;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;

public final class Strings
extends Static {
    public static final char CONTINUATION_MARK = '\u2503';
    public static final char CONTINUATION_END = '\u2579';
    public static final String CONTINUATION_ITEM = "\u25b6\u00a0";

    private Strings() {
    }

    public static boolean appendUnicodeIdentifier(StringBuilder appendTo, char separator, String text, String accepted, boolean toLowerCase) {
        boolean added = false;
        boolean toUpperCase = false;
        if (text != null) {
            int c;
            for (int i = 0; i < text.length(); i += Character.charCount(c)) {
                boolean isFirst;
                c = text.codePointAt(i);
                boolean bl = isFirst = appendTo.length() == 0;
                if ((!isFirst ? Character.isUnicodeIdentifierPart(c) : Character.isUnicodeIdentifierStart(c)) || accepted.indexOf(c) >= 0) {
                    if (!isFirst && !added && separator != '\u0000') {
                        appendTo.append(separator);
                    }
                    appendTo.appendCodePoint(toLowerCase ? Character.toLowerCase(c) : (toUpperCase ? Character.toUpperCase(c) : c));
                    added = true;
                    toUpperCase = false;
                    continue;
                }
                toUpperCase = true;
            }
        }
        return added;
    }

    public static String toIndexed(String name, int index) {
        return name + '[' + index + ']';
    }

    public static String bracket(String name, Object index) {
        if (index instanceof CharSequence) {
            return name + "[\u201c" + index + "\u201d]";
        }
        return name + '[' + index + ']';
    }

    public static String bracket(Class<?> type, Object index) {
        return Strings.bracket(Classes.getShortName(type), index);
    }

    public static String range(Class<?> type, Object lower, Object upper) {
        return Classes.getShortName(type) + '[' + lower + " \u2026 " + upper + ']';
    }

    public static String toUpperCase(String text, Characters.Filter filter) {
        int c;
        int length = text.length();
        int i = 0;
        while (true) {
            if (i >= length) {
                return text;
            }
            c = text.codePointAt(i);
            if (!filter.contains(c) || Character.toUpperCase(c) != c) break;
            i += Character.charCount(c);
        }
        StringBuilder buffer = new StringBuilder(length).append(text, 0, i);
        while (i < length) {
            c = text.codePointAt(i);
            if (filter.contains(c)) {
                buffer.appendCodePoint(Character.toUpperCase(c));
            }
            i += Character.charCount(c);
        }
        return buffer.toString();
    }

    public static void insertLineInLeftMargin(StringBuilder buffer, String lineSeparator) {
        int c = 9593;
        int i = CharSequences.skipTrailingWhitespaces(buffer, 0, buffer.length());
        while ((i = buffer.lastIndexOf(lineSeparator, i - 1)) >= 0) {
            buffer.insert(i + lineSeparator.length(), (char)c);
            c = 9475;
        }
    }

    public static String toString(Class<?> classe, Object ... properties) {
        StringBuilder buffer = new StringBuilder(32).append(Classes.getShortName(classe)).append('[');
        boolean isNext = false;
        for (int i = 0; i < properties.length; ++i) {
            Object name;
            Object value;
            if ((value = properties[++i]) == null) continue;
            if (isNext) {
                buffer.append(", ");
            }
            if ((name = properties[i - 1]) != null) {
                buffer.append(name).append('=');
            }
            if (value.getClass().isArray()) {
                int n = Array.getLength(value);
                if (n != 1) {
                    buffer.append('{');
                }
                for (int j = 0; j < n; ++j) {
                    if (j != 0) {
                        buffer.append(", ");
                    }
                    Strings.append(Array.get(value, j), buffer);
                }
                if (n != 1) {
                    buffer.append('}');
                }
            } else {
                Strings.append(value, buffer);
            }
            isNext = true;
        }
        return buffer.append(']').toString();
    }

    private static void append(Object value, StringBuilder buffer) {
        boolean isText = value instanceof CharSequence;
        if (isText) {
            buffer.append('\u201c');
        }
        buffer.append(value);
        if (isText) {
            buffer.append('\u201d');
        }
    }

    public static void formatTo(Formatter formatter, int flags, int width, int precision, String value) {
        Object[] args;
        String format;
        boolean isUpperCase;
        boolean bl = isUpperCase = (flags & 2) != 0;
        if (isUpperCase && width > 0) {
            value = value.toUpperCase(formatter.locale());
            isUpperCase = false;
        }
        int length = value.length();
        if (precision >= 0) {
            int n = 0;
            for (int i = 0; i < length; i += n) {
                if (--precision < 0) {
                    if (n == 0) {
                        value = "";
                        break;
                    }
                    length = (i -= n) + 1;
                    StringBuilder buffer = new StringBuilder(length);
                    value = buffer.append(value, 0, i).append('\u2026').toString();
                    break;
                }
                n = Character.charCount(value.codePointAt(i));
            }
        }
        if (width > length && (width -= value.codePointCount(0, length)) > 0) {
            format = "%s%s";
            args = new Object[]{value, value};
            args[(flags & 1) != 0 ? 1 : 0] = CharSequences.spaces(width);
        } else {
            format = isUpperCase ? "%S" : "%s";
            args = new Object[]{value};
        }
        formatter.format(format, args);
    }
}

