/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.Vector;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;

public final class Numerics
extends Static {
    private static final Map<Object, Object> CACHE = new HashMap<Object, Object>(32);
    public static final int MAXIMUM_MATRIX_SIZE = Short.MAX_VALUE;
    public static final double COMPARISON_THRESHOLD = 1.0E-13;
    public static final long SIGN_BIT_MASK = Long.MIN_VALUE;
    public static final int SIGNIFICAND_SIZE = 52;
    public static final int SIGNIFICAND_SIZE_OF_FLOAT = 23;

    private static void cache(double value) {
        Double boxed = value;
        CACHE.put(boxed, boxed);
        boxed = -value;
        CACHE.put(boxed, boxed);
    }

    private Numerics() {
    }

    public static long bitmask(int bit) {
        return bit >= 0 && bit < 64 ? 1L << bit : 0L;
    }

    public static int ceilDiv(int x, int y) {
        int r = x / y;
        if ((x ^ y) >= 0 && r * y != x) {
            ++r;
        }
        return r;
    }

    public static long ceilDiv(long x, long y) {
        long r = x / y;
        if ((x ^ y) >= 0L && r * y != x) {
            ++r;
        }
        return r;
    }

    public static long multiplyDivide(long value, long multiplier, long divisor) {
        return Math.multiplyExact(value, multiplier) / divisor;
    }

    public static <T> T cached(T value) {
        return (T)CACHE.getOrDefault(value, value);
    }

    public static Double valueOf(double value) {
        Double boxed = value;
        return (Double)CACHE.getOrDefault(boxed, boxed);
    }

    public static boolean equals(float v1, float v2) {
        return Float.floatToIntBits(v1) == Float.floatToIntBits(v2);
    }

    public static boolean equals(double v1, double v2) {
        return Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2);
    }

    public static boolean equalsIgnoreZeroSign(double v1, double v2) {
        return v1 == v2 || Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2);
    }

    public static boolean epsilonEqual(double v1, double v2, double threshold) {
        return Math.abs(v1 - v2) <= threshold || Numerics.equals(v1, v2);
    }

    public static boolean epsilonEqual(double v1, double v2, ComparisonMode mode) {
        double mg;
        if (mode.isApproximate() && (mg = Math.max(Math.abs(v1), Math.abs(v2))) != Double.POSITIVE_INFINITY) {
            return Numerics.epsilonEqual(v1, v2, 1.0E-13 * mg);
        }
        return Numerics.equals(v1, v2);
    }

    public static String messageForDifference(String name, double v1, double v2) {
        StringBuilder builder = new StringBuilder();
        if (name != null) {
            builder.append(name).append(": ");
        }
        builder.append("values ").append(v1).append(" and ").append(v2).append(" differ");
        float delta = (float)Math.abs(v1 - v2);
        if (delta < Float.POSITIVE_INFINITY) {
            builder.append(" by ").append(delta);
        }
        return builder.toString();
    }

    public static boolean isUnsignedInteger(String text) {
        int length;
        if (text != null && (length = text.length()) != 0) {
            char c;
            int i = 0;
            while ((c = text.charAt(i)) >= '0' && c <= '9') {
                if (++i < length) continue;
                return true;
            }
        }
        return false;
    }

    public static float toUnsignedFloat(long value) {
        if (value >= 0L) {
            return value;
        }
        return Float.parseFloat(Long.toUnsignedString(value));
    }

    public static double toUnsignedDouble(long value) {
        if (value >= 0L) {
            return value;
        }
        return Double.parseDouble(Long.toUnsignedString(value));
    }

    public static int toExp10(int exp2) {
        assert (exp2 >= -2620 && exp2 <= 2620) : exp2;
        return exp2 * 315653 >> 20;
    }

    public static long getSignificand(double value) {
        long bits = Double.doubleToRawLongBits(value);
        long exponent = bits & 0x7FF0000000000000L;
        bits &= 0xFFFFFFFFFFFFFL;
        bits = exponent != 0L ? (bits |= 0x10000000000000L) : (bits <<= 1);
        return bits;
    }

    public static int getSignificand(float value) {
        int bits = Float.floatToRawIntBits(value);
        int exponent = bits & 0x7F800000;
        bits = (int)((long)bits & 0x7FFFFFL);
        bits = exponent != 0 ? (int)((long)bits | 0x800000L) : (bits <<= 1);
        return bits;
    }

    public static int fractionDigitsForDelta(double ulp) {
        return ulp != 0.0 ? Math.max(0, Math.min(16, DecimalFunctions.fractionDigitsForDelta(ulp, false))) : 0;
    }

    public static int suggestFractionDigits(double ... values) {
        double ulp = 0.0;
        if (values != null) {
            for (double v : values) {
                double e = Math.ulp(v);
                if (!(e > ulp) || e == Double.POSITIVE_INFINITY) continue;
                ulp = e;
            }
        }
        return Numerics.fractionDigitsForDelta(ulp);
    }

    public static int suggestFractionDigits(Statistics stats) {
        double minimum = stats.minimum();
        double maximum = stats.maximum();
        double delta = stats.standardDeviation(true);
        if (delta == 0.0) {
            delta = stats.span();
            if (delta == 0.0) {
                delta = Math.abs(maximum) / 1000000.0;
            }
        } else {
            double mean = stats.mean();
            delta *= 2.0;
            delta = Math.min(maximum, mean + delta) - Math.max(minimum, mean - delta);
            delta /= Math.min((double)stats.count() * 100.0, 1000000.0);
            delta = Math.max(delta, Math.max(Math.ulp(minimum), Math.ulp(maximum)));
        }
        return Numerics.fractionDigitsForDelta(delta);
    }

    public static int[] suggestFractionDigits(Vector[] rows) {
        int length = 0;
        int n = rows.length - 1;
        for (int j = 0; j <= n; ++j) {
            int rl = rows[j].size();
            if (rl <= length) continue;
            length = rl;
        }
        int[] fractionDigits = new int[length];
        Statistics stats = new Statistics(null);
        for (int i = 0; i < length; ++i) {
            boolean isInteger = true;
            for (Vector row : rows) {
                if (row.size() <= i) continue;
                double value = row.doubleValue(i);
                stats.accept(value);
                if (!isInteger || Math.floor(value) == value || Double.isNaN(value)) continue;
                isInteger = false;
            }
            if (!isInteger) {
                fractionDigits[i] = Numerics.suggestFractionDigits(stats);
            }
            stats.reset();
        }
        return fractionDigits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String useScientificNotationIfNeeded(Format format, Object value, BiFunction<Format, Object, String> action) {
        double m;
        if (value instanceof Number && (m = Math.abs(((Number)value).doubleValue())) > 0.0 && (m >= 1.0E9 || m < 1.0E-4) && format instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)format;
            String pattern = df.toPattern();
            df.applyPattern("0.######E00");
            try {
                String string = action.apply(format, value);
                return string;
            }
            finally {
                df.applyPattern(pattern);
            }
        }
        return action.apply(format, value);
    }

    static {
        Numerics.cache(0.0);
        Numerics.cache(1.0);
        Numerics.cache(10.0);
        Numerics.cache(60.0);
        Numerics.cache(90.0);
        Numerics.cache(100.0);
        Numerics.cache(180.0);
        Numerics.cache(648000.0);
        Numerics.cache(360.0);
        Numerics.cache(1000.0);
        Numerics.cache(Double.POSITIVE_INFINITY);
    }
}

