/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;

public final class DefinitionURI {
    public static final String PREFIX = "urn:ogc:def";
    public static final char SEPARATOR = ':';
    public static final char COMPONENT_SEPARATOR = ',';
    private static final char COMPONENT_SEPARATOR_1 = '?';
    private static final char COMPONENT_SEPARATOR_2 = '&';
    private static final char KEY_VALUE_SEPARATOR = '=';
    public static final String DOMAIN = "www.opengis.net";
    private static final Map<String, String> PATHS = Collections.singletonMap("crs", "//www.opengis.net/gml/srs/");
    public static final String NO_VERSION = "0";
    public boolean isHTTP;
    public boolean isGML;
    public String type;
    public String authority;
    public String version;
    public String code;
    public String[] parameters;
    public DefinitionURI[] components;

    private DefinitionURI() {
    }

    public static DefinitionURI parse(String uri) {
        ArgumentChecks.ensureNonNull("uri", uri);
        return DefinitionURI.parse(uri, false, -1, uri.length());
    }

    private static DefinitionURI parse(String uri, boolean prefixIsOptional, int upper, int stopAt) {
        DefinitionURI result = null;
        int separator = 58;
        int componentSeparator = 44;
        block14: for (int part = 0; part <= 6; ++part) {
            int lower = upper + 1;
            if (((upper = uri.indexOf(separator, lower)) < 0 || upper >= stopAt) && lower > (upper = stopAt)) {
                return result;
            }
            switch (part) {
                case 0: {
                    if (DefinitionURI.regionMatches("http", uri, lower, upper)) {
                        result = new DefinitionURI();
                        result.isHTTP = true;
                        if (DefinitionURI.codeForGML(null, null, uri, ++upper, result) != null) {
                            return result;
                        }
                        if (!uri.regionMatches(upper, "//", 0, 2)) {
                            return null;
                        }
                        ++upper;
                        separator = 47;
                        componentSeparator = 63;
                        prefixIsOptional = false;
                        continue block14;
                    }
                    if (DefinitionURI.regionMatches("urn", uri, lower, upper)) {
                        prefixIsOptional = false;
                        continue block14;
                    }
                    if (!prefixIsOptional) {
                        return null;
                    }
                    ++part;
                }
                case 1: {
                    boolean isHTTP = separator != 58;
                    if (DefinitionURI.regionMatches(isHTTP ? DOMAIN : "ogc", uri, lower, upper) || !isHTTP && DefinitionURI.regionMatches("x-ogc", uri, lower, upper)) {
                        prefixIsOptional = false;
                        continue block14;
                    }
                    if (!prefixIsOptional) {
                        return null;
                    }
                    ++part;
                }
                case 2: {
                    if (DefinitionURI.regionMatches("def", uri, lower, upper)) {
                        prefixIsOptional = false;
                        continue block14;
                    }
                    if (!prefixIsOptional) {
                        return null;
                    }
                    ++part;
                }
                case 3: {
                    int splitAt = uri.indexOf(componentSeparator, lower);
                    if (splitAt >= 0 && splitAt < stopAt) {
                        boolean hasMore;
                        int componentsEnd = stopAt;
                        stopAt = splitAt;
                        if (stopAt < upper) {
                            upper = stopAt;
                        }
                        if (componentSeparator == 63) {
                            componentSeparator = 38;
                        }
                        if (result == null) {
                            result = new DefinitionURI();
                        }
                        boolean isURN = !result.isHTTP;
                        TreeMap<Integer, DefinitionURI> orderedComponents = new TreeMap<Integer, DefinitionURI>();
                        do {
                            int next;
                            boolean bl = hasMore = (next = uri.indexOf(componentSeparator, splitAt + 1)) >= 0 && next < componentsEnd;
                            if (!hasMore) {
                                next = componentsEnd;
                            }
                            int sequenceNumber = orderedComponents.size() + 1;
                            int s = DefinitionURI.splitKeyValue(uri, splitAt + 1, next);
                            if (s >= 0) {
                                try {
                                    sequenceNumber = Integer.parseInt(CharSequences.trimWhitespaces(uri, splitAt + 1, s).toString());
                                    splitAt = s;
                                }
                                catch (NumberFormatException e) {
                                    Logging.recoverableException(Logging.getLogger("org.apache.sis.referencing.factory"), DefinitionURI.class, "parse", e);
                                }
                            }
                            orderedComponents.put(sequenceNumber, DefinitionURI.parse(uri, isURN, splitAt, next));
                            splitAt = next;
                        } while (hasMore);
                        result.components = orderedComponents.values().toArray(new DefinitionURI[orderedComponents.size()]);
                    }
                }
                default: {
                    String value = CharSequences.trimWhitespaces(uri, lower, upper).toString();
                    if (value.isEmpty() || part == 5 && NO_VERSION.equals(value)) continue block14;
                    if (result == null) {
                        result = new DefinitionURI();
                    }
                    switch (part) {
                        case 3: {
                            result.type = value;
                            continue block14;
                        }
                        case 4: {
                            result.authority = value;
                            continue block14;
                        }
                        case 5: {
                            result.version = value;
                            continue block14;
                        }
                        case 6: {
                            result.code = value;
                            continue block14;
                        }
                    }
                    throw new AssertionError(part);
                }
            }
        }
        if (result != null && ++upper < stopAt) {
            result.parameters = (String[])CharSequences.split(uri.substring(upper), (char)separator);
        }
        return result;
    }

    static boolean regionMatches(String part, String urn, int lower, int upper) {
        int length = (upper = CharSequences.skipTrailingWhitespaces(urn, lower = CharSequences.skipLeadingWhitespaces(urn, lower, upper), upper)) - lower;
        return length == part.length() && urn.regionMatches(true, lower, part, 0, length);
    }

    private static int splitKeyValue(String uri, int lower, int upper) {
        while (lower < upper) {
            int c = uri.codePointAt(lower);
            if (!(c >= 48 && c <= 57 || Character.isWhitespace(c))) {
                if (c != 61) break;
                return lower;
            }
            lower += Character.charCount(c);
        }
        return -1;
    }

    private static String codeIgnoreVersion(String urn, int fromIndex) {
        int length = urn.length();
        if ((fromIndex = CharSequences.skipLeadingWhitespaces(urn, fromIndex, length)) >= length) {
            return null;
        }
        int s = urn.indexOf(58, fromIndex);
        if (s >= 0 && ((fromIndex = CharSequences.skipLeadingWhitespaces(urn, s + 1, length)) >= length || urn.indexOf(58, fromIndex) >= 0)) {
            return null;
        }
        return urn.substring(fromIndex, CharSequences.skipTrailingWhitespaces(urn, fromIndex, length));
    }

    public static String codeOf(String type, String authority, String uri) {
        String part;
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonNull("authority", authority);
        ArgumentChecks.ensureNonNull("uri", uri);
        int upper = uri.indexOf(58);
        if (upper < 0) {
            return CharSequences.trimWhitespaces(uri);
        }
        int lower = CharSequences.skipLeadingWhitespaces(uri, 0, upper);
        int length = CharSequences.skipTrailingWhitespaces(uri, lower, upper) - lower;
        if (length == authority.length() && uri.regionMatches(true, lower, authority, 0, length)) {
            return DefinitionURI.codeIgnoreVersion(uri, upper + 1);
        }
        switch (length) {
            case 3: {
                part = "urn";
                break;
            }
            case 4: {
                part = "http";
                break;
            }
            default: {
                return null;
            }
        }
        if (!uri.regionMatches(true, lower, part, 0, length)) {
            return null;
        }
        if (length == 4) {
            return DefinitionURI.codeForGML(type, authority, uri, upper + 1, null);
        }
        block10: for (int p = 0; p != 4; ++p) {
            lower = upper + 1;
            if ((upper = uri.indexOf(58, lower)) < 0) {
                return null;
            }
            switch (p) {
                case 0: {
                    if (DefinitionURI.regionMatches("ogc", uri, lower, upper)) continue block10;
                    part = "x-ogc";
                    break;
                }
                case 1: {
                    part = "def";
                    break;
                }
                case 2: {
                    part = type;
                    break;
                }
                case 3: {
                    part = authority;
                    break;
                }
                default: {
                    throw new AssertionError(p);
                }
            }
            if (DefinitionURI.regionMatches(part, uri, lower, upper)) continue;
            return null;
        }
        return DefinitionURI.codeIgnoreVersion(uri, upper + 1);
    }

    private static String codeForGML(String type, String authority, String url, int lower, DefinitionURI result) {
        String path;
        Map<String, String> paths = PATHS;
        if (type != null && (path = paths.get(type)) == null) {
            return null;
        }
        block4: for (Map.Entry<String, String> entry : paths.entrySet()) {
            int upper;
            String path2 = entry.getValue();
            if (!url.regionMatches(true, lower, path2, 0, path2.length())) continue;
            lower = CharSequences.skipLeadingWhitespaces(url, lower + path2.length(), url.length());
            if (authority == null) {
                authority = url.substring(lower, DefinitionURI.skipIdentifierPart(url, lower));
            } else if (!url.regionMatches(true, lower, authority, 0, authority.length())) continue;
            if ((lower += authority.length()) >= (upper = url.length())) continue;
            switch (url.charAt(lower)) {
                case '.': {
                    lower = url.indexOf(35, lower + 1);
                    if (lower < 0) continue block4;
                }
                case '#': {
                    String code = CharSequences.trimWhitespaces(url, lower + 1, upper).toString();
                    if (result != null) {
                        result.isGML = true;
                        result.type = entry.getKey();
                        result.authority = authority;
                        result.code = code;
                    }
                    return code;
                }
            }
        }
        return null;
    }

    private static int skipIdentifierPart(String text, int i) {
        int c;
        while (i < text.length() && Character.isUnicodeIdentifierPart(c = text.codePointAt(i))) {
            i += Character.charCount(c);
        }
        return i;
    }

    public String toString() {
        String path;
        if (this.isGML && (path = PATHS.get(this.type)) != null) {
            return "http:" + path + this.authority + ".xml#" + this.code;
        }
        StringBuilder buffer = new StringBuilder(40);
        if (!this.isHTTP) {
            buffer.append(PREFIX);
        }
        this.appendStringTo(buffer, ':');
        return buffer.toString();
    }

    private void appendStringTo(StringBuilder buffer, char separator) {
        if (this.isHTTP) {
            buffer.append("http://").append(DOMAIN).append("/def");
            separator = (char)47;
        }
        int n = 4;
        if (this.parameters != null) {
            n += this.parameters.length;
        }
        for (int p = 0; p < n; ++p) {
            String part;
            switch (p) {
                case 0: {
                    part = this.type;
                    break;
                }
                case 1: {
                    part = this.authority;
                    break;
                }
                case 2: {
                    part = this.version;
                    break;
                }
                case 3: {
                    part = this.code;
                    break;
                }
                default: {
                    part = this.parameters[p - 4];
                }
            }
            buffer.append(separator);
            if (this.isHTTP) {
                if (part == null) {
                    part = NO_VERSION;
                }
            } else {
                separator = (char)58;
                if (part == null) continue;
            }
            buffer.append(part);
        }
        int length = buffer.length();
        int n2 = n = this.isHTTP ? 2 : 1;
        while (!((length -= n) < 0 || buffer.charAt(length) != separator || this.isHTTP && buffer.charAt(length + 1) != NO_VERSION.charAt(0))) {
            buffer.setLength(length);
        }
        if (this.components != null) {
            int i = 0;
            while (i < this.components.length) {
                DefinitionURI c = this.components[i++];
                if (this.isHTTP) {
                    buffer.append(i == 1 ? (char)'?' : '&').append(i).append('=');
                }
                c.appendStringTo(buffer, ',');
            }
        }
    }
}

