/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.sis.internal.system.Threads;
import org.apache.sis.util.logging.Logging;

public final class Shutdown
extends Thread {
    private static String container;
    private static Shutdown hook;
    private static final List<Callable<?>> resources;

    private Shutdown() {
        super(Threads.SIS, "Shutdown");
    }

    @Override
    public void run() {
        try {
            Shutdown.stop(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContainer() {
        List<Callable<?>> list = resources;
        synchronized (list) {
            return container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContainer(String env) {
        Objects.requireNonNull(env);
        List<Callable<?>> list = resources;
        synchronized (list) {
            Shutdown.removeShutdownHook();
            container = env;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Callable<?> resource) {
        List<Callable<?>> list = resources;
        synchronized (list) {
            assert (!resources.contains(resource));
            resources.add(resource);
            if (hook == null && container == null) {
                hook = new Shutdown();
                Runtime.getRuntime().addShutdownHook(hook);
            }
        }
    }

    private static void removeShutdownHook() {
        assert (Thread.holdsLock(resources));
        if (hook != null) {
            Runtime.getRuntime().removeShutdownHook(hook);
            hook = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Callable<?> resource) {
        List<Callable<?>> list = resources;
        synchronized (list) {
            int i = resources.size();
            while (--i >= 0) {
                if (resources.get(i) != resource) continue;
                resources.remove(i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(Class<?> caller) throws Exception {
        Exception exception;
        block14: {
            List<Callable<?>> list = resources;
            synchronized (list) {
                container = "Shutdown";
                if (caller != null) {
                    Shutdown.removeShutdownHook();
                }
            }
            exception = null;
            List<Callable<?>> list2 = resources;
            synchronized (list2) {
                int i;
                while ((i = resources.size()) != 0) {
                    try {
                        resources.remove(i - 1).call();
                    }
                    catch (Exception e) {
                        if (exception != null) {
                            e.addSuppressed(exception);
                        }
                        exception = e;
                    }
                }
            }
            try {
                Threads.shutdown(System.nanoTime() + 4000L);
            }
            catch (InterruptedException e) {
                if (caller == null) break block14;
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.system"), caller, "stop", e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    static {
        resources = new ArrayList();
    }
}

