/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

public final class Semaphores {
    public static final int NULL_COLLECTION = 1;
    public static final int METADATA_ONLY = 2;
    public static final int CONVERSION_AND_CRS = 4;
    public static final int ENCLOSED_IN_OPERATION = 8;
    public static final int SUSPEND_PARAMETER_CHECK = 16;
    private static final ThreadLocal<Semaphores> FLAGS = new ThreadLocal();
    private int flags;

    private Semaphores() {
    }

    public static boolean query(int flag) {
        Semaphores s = FLAGS.get();
        return s != null && (s.flags & flag) != 0;
    }

    public static boolean queryAndSet(int flag) {
        Semaphores s = FLAGS.get();
        if (s == null) {
            s = new Semaphores();
            FLAGS.set(s);
        }
        boolean isSet = (s.flags & flag) != 0;
        s.flags |= flag;
        return isSet;
    }

    public static void clear(int flag) {
        Semaphores s = FLAGS.get();
        if (s != null) {
            s.flags &= ~flag;
        }
    }
}

