/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.apache.sis.internal.system.DaemonThread;
import org.apache.sis.internal.system.Threads;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.logging.Logging;

public final class ReferenceQueueConsumer
extends DaemonThread {
    public static final ReferenceQueue<Object> QUEUE = new ReferenceQueue();

    private ReferenceQueueConsumer(DaemonThread lastCreatedDaemon) {
        super("ReferenceQueueConsumer", lastCreatedDaemon);
        this.setPriority(8);
    }

    @Override
    public final void run() {
        ReferenceQueue<Object> queue;
        while ((queue = QUEUE) != null) {
            try {
                Reference<Object> ref = queue.remove();
                if (ref != null) {
                    ((Disposable)((Object)ref)).dispose();
                    continue;
                }
            }
            catch (InterruptedException ref) {
            }
            catch (Throwable exception) {
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.system"), this.getClass(), "run", exception);
            }
            if (!this.isKillRequested()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<Threads> clazz = Threads.class;
        synchronized (Threads.class) {
            ReferenceQueueConsumer thread = new ReferenceQueueConsumer(Threads.lastCreatedDaemon);
            Threads.lastCreatedDaemon = thread;
            thread.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

