/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import org.apache.sis.util.logging.Logging;

public enum OS {
    UNKNOWN,
    WINDOWS,
    MAC_OS,
    LINUX;


    public static String uname() {
        try {
            return System.getProperty("os.name");
        }
        catch (SecurityException e) {
            Logging.recoverableException(Logging.getLogger("org.apache.sis.system"), OS.class, "uname", e);
            return null;
        }
    }

    public static OS current() {
        String name = OS.uname();
        if (name != null) {
            if (name.contains("Windows")) {
                return WINDOWS;
            }
            if (name.contains("Mac OS")) {
                return MAC_OS;
            }
            if (name.contains("Linux")) {
                return LINUX;
            }
        }
        return UNKNOWN;
    }
}

