/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.wkt;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.wkt.StoreFormat;
import org.apache.sis.internal.storage.wkt.StoreProvider;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.util.CharSequences;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;

final class Store
extends URIDataStore {
    private static final int SIZE_LIMIT = 1000000;
    private Reader source;
    private final GeometryLibrary library;
    private final List<Object> objects = new ArrayList<Object>();
    private Metadata metadata;

    public Store(StoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.source = connector.getStorageAs(Reader.class);
        connector.closeAllExcept(this.source);
        if (this.source == null) {
            throw new UnsupportedStorageException(super.getLocale(), "WKT", connector.getStorage(), connector.getOption(OptionKey.OPEN_OPTIONS));
        }
        this.library = connector.getOption(OptionKey.GEOMETRY_LIBRARY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws DataStoreException {
        Reader in = this.source;
        if (in != null) {
            try {
                String wkt;
                this.source = null;
                try {
                    int n;
                    char[] buffer = new char[2048];
                    int length = 0;
                    while ((n = in.read(buffer, length, buffer.length - length)) >= 0) {
                        if ((length += n) < buffer.length) continue;
                        if (n >= 1000000) {
                            throw new DataStoreContentException(Resources.format((short)6, this.getDisplayName(), 1000000, n));
                        }
                        buffer = Arrays.copyOf(buffer, n << 1);
                    }
                    wkt = String.valueOf(buffer, 0, length);
                }
                finally {
                    in.close();
                }
                ParsePosition pos = new ParsePosition(0);
                StoreFormat parser = new StoreFormat(this.library, this.listeners);
                do {
                    Object obj = parser.parse(wkt, pos);
                    this.objects.add(obj);
                    pos.setIndex(CharSequences.skipLeadingWhitespaces(wkt, pos.getIndex(), wkt.length()));
                    parser.validate(obj);
                } while (pos.getIndex() < wkt.length());
            }
            catch (ParseException e) {
                throw new DataStoreContentException(this.getLocale(), "WKT", this.getDisplayName(), (Object)in).initCause(e);
            }
            catch (IOException e) {
                throw new DataStoreException(this.getLocale(), "WKT", this.getDisplayName(), (Object)in).initCause(e);
            }
        }
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.parse();
            MetadataBuilder builder = new MetadataBuilder();
            String name = null;
            int count = 0;
            for (Object object : this.objects) {
                if (!(object instanceof ReferenceSystem)) continue;
                ReferenceSystem rs = (ReferenceSystem)object;
                builder.addReferenceSystem(rs);
                name = IdentifiedObjects.getName((IdentifiedObject)rs, null);
                ++count;
                builder.addIdentifier(IdentifiedObjects.getIdentifier((IdentifiedObject)rs, null), MetadataBuilder.Scope.RESOURCE);
            }
            if (count == 1) {
                builder.addTitle(name);
            } else {
                this.addTitleOrIdentifier(builder);
            }
            this.metadata = builder.build(true);
        }
        return this.metadata;
    }

    @Override
    public synchronized void close() throws DataStoreException {
        Reader s = this.source;
        this.source = null;
        this.objects.clear();
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
        }
    }
}

