/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.wkt;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.Characters;

public abstract class FirstKeywordPeek {
    protected static final int REJECT = 0;
    protected static final int ACCEPT = 1;
    protected static final int IGNORE = 2;
    static final int READ_AHEAD_LIMIT = 2048;
    protected static final char COMMENT = '#';
    protected final int maxLength;

    public FirstKeywordPeek(int maxLength) {
        this.maxLength = maxLength;
    }

    private static int nextAfterSpaces(ByteBuffer buffer, Reader reader) throws IOException {
        int c;
        if (buffer != null) {
            while (buffer.hasRemaining()) {
                char c2 = (char)buffer.get();
                if (Character.isWhitespace(c2)) continue;
                return c2;
            }
            return -1;
        }
        while ((c = IOUtilities.readCodePoint(reader)) >= 0 && Character.isWhitespace(c)) {
        }
        return c;
    }

    private static void toEndOfLine(ByteBuffer buffer, Reader reader) throws IOException {
        int c;
        do {
            if (buffer != null) {
                if (!buffer.hasRemaining()) break;
                c = (char)buffer.get();
                continue;
            }
            c = IOUtilities.readCodePoint(reader);
            if (c < 0) break;
        } while (!Characters.isLineOrParagraphSeparator(c));
    }

    protected int isKeywordChar(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95 ? 1 : 0;
    }

    public final ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        char[] keyword = null;
        int pos = 0;
        try {
            int c;
            Reader reader;
            ByteBuffer buffer = connector.getStorageAs(ByteBuffer.class);
            if (buffer != null) {
                buffer.mark();
                reader = null;
            } else {
                reader = connector.getStorageAs(Reader.class);
                if (reader == null) {
                    return ProbeResult.UNSUPPORTED_STORAGE;
                }
                reader.mark(2048);
            }
            while ((c = FirstKeywordPeek.nextAfterSpaces(buffer, reader)) == 35) {
                FirstKeywordPeek.toEndOfLine(buffer, reader);
            }
            int s = this.isKeywordChar(c);
            if (s >= 1) {
                keyword = new char[this.maxLength];
                do {
                    if (s != 1) continue;
                    if (pos >= keyword.length) {
                        pos = 0;
                        break;
                    }
                    keyword[pos++] = (char)c;
                } while ((s = this.isKeywordChar(c = buffer == null ? IOUtilities.readCodePoint(reader) : (buffer.hasRemaining() ? (int)buffer.get() : -1))) >= 1);
                if (Character.isWhitespace(c)) {
                    c = FirstKeywordPeek.nextAfterSpaces(buffer, reader);
                }
                if (!this.isPostKeyword(c)) {
                    pos = 0;
                }
            }
            if (buffer != null) {
                buffer.reset();
            } else {
                reader.reset();
            }
            if (c < 0) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        return this.forKeyword(keyword, pos);
    }

    protected abstract boolean isPostKeyword(int var1);

    protected abstract ProbeResult forKeyword(char[] var1, int var2);
}

