/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.query;

import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.storage.query.FeatureSubset;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.Query;
import org.apache.sis.util.ArgumentChecks;

public class SimpleQuery
extends Query {
    private static final long UNLIMITED = -1L;
    private long skip;
    private long limit = -1L;

    public void setOffset(long skip) {
        ArgumentChecks.ensurePositive("skip", skip);
        this.skip = skip;
    }

    public long getOffset() {
        return this.skip;
    }

    public void setLimit(long limit) {
        if (limit != -1L) {
            ArgumentChecks.ensurePositive("limit", limit);
        }
        this.limit = limit;
    }

    public long getLimit() {
        return this.limit;
    }

    public FeatureSet execute(FeatureSet source) {
        ArgumentChecks.ensureNonNull("source", source);
        return new FeatureSubset(source, this);
    }

    final DefaultFeatureType expectedType(DefaultFeatureType valueType) {
        return valueType;
    }

    public int hashCode() {
        return Long.hashCode(this.limit ^ this.skip);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            SimpleQuery other = (SimpleQuery)obj;
            return this.skip == other.skip && this.limit == other.limit;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("SELECT ");
        sb.append('*');
        if (this.limit != -1L) {
            sb.append(" LIMIT ").append(this.limit);
        }
        if (this.skip != 0L) {
            sb.append(" OFFSET ").append(this.skip);
        }
        return sb.toString();
    }
}

