/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.internal.storage.gpx.Metadata;
import org.apache.sis.internal.storage.gpx.Store;
import org.apache.sis.internal.storage.xml.stream.StaxDataStoreProvider;
import org.apache.sis.measure.Range;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.Version;

@StoreMetadata(formatName="GPX", fileSuffixes={"xml"}, capabilities={Capability.READ, Capability.WRITE})
public final class StoreProvider
extends StaxDataStoreProvider {
    static final Version V1_0 = Version.valueOf(1, 0);
    static final Version V1_1 = Version.valueOf(1, 1);
    private static final Range<Version> VERSIONS = new Range<Version>(Version.class, V1_0, true, V1_1, true);

    public StoreProvider() {
        super("GPX");
        this.mimeForNameSpaces.put("http://www.topografix.com/GPX/1/0", "application/gpx+xml");
        this.mimeForNameSpaces.put("http://www.topografix.com/GPX/1/1", "application/gpx+xml");
        this.mimeForRootElements.put("gpx", "application/gpx+xml");
    }

    @Override
    public Range<Version> getSupportedVersions() {
        return VERSIONS;
    }

    @Override
    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new Store(this, connector);
    }

    @Override
    protected JAXBContext getJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{Metadata.class});
    }
}

