/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.storage.StoreUtilities;
import org.apache.sis.internal.storage.gpx.Metadata;
import org.apache.sis.internal.storage.gpx.Reader;
import org.apache.sis.internal.storage.gpx.StoreProvider;
import org.apache.sis.internal.storage.gpx.Types;
import org.apache.sis.internal.storage.gpx.Writer;
import org.apache.sis.internal.storage.xml.stream.StaxDataStore;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.distribution.DefaultFormat;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.IllegalNameException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.distribution.Format;
import org.opengis.util.FactoryException;
import org.opengis.util.NameFactory;

public final class Store
extends StaxDataStore
implements FeatureSet {
    Version version;
    private org.opengis.metadata.Metadata metadata;
    private Reader reader;
    final Types types;

    public Store(StoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        GeometryLibrary library = connector.getOption(OptionKey.GEOMETRY_LIBRARY);
        if (library == null || Types.DEFAULT.geometries.library == library) {
            this.types = Types.DEFAULT;
        } else {
            try {
                this.types = new Types(DefaultFactories.forBuildin(NameFactory.class, DefaultNameFactory.class), null, library);
            }
            catch (FactoryException e) {
                throw new DataStoreException(e);
            }
        }
    }

    final Format getFormat() {
        assert (Thread.holdsLock(this));
        Format format = ((StoreProvider)this.provider).getFormat(this.listeners);
        if (this.version != null) {
            DefaultFormat df = new DefaultFormat(format);
            DefaultCitation citation = new DefaultCitation(df.getFormatSpecificationCitation());
            citation.setEdition(new SimpleInternationalString(this.version.toString()));
            df.setFormatSpecificationCitation(citation);
            format = df;
        }
        return format;
    }

    public synchronized Version getVersion() throws DataStoreException {
        if (this.version == null) {
            this.getMetadata();
        }
        return this.version;
    }

    public synchronized void setVersion(Version version) throws DataStoreException {
        ArgumentChecks.ensureNonNull("version", version);
        this.version = version;
    }

    @Override
    public synchronized org.opengis.metadata.Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            try {
                this.reader = new Reader(this);
                this.version = this.reader.initialize(true);
                this.metadata = this.reader.getMetadata();
            }
            catch (DataStoreException e) {
                throw e;
            }
            catch (RuntimeException | URISyntaxException e) {
                throw new DataStoreContentException(e);
            }
            catch (Exception e) {
                throw new DataStoreException(e);
            }
        }
        return this.metadata;
    }

    @Override
    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.ofNullable(StoreUtilities.getEnvelope(this.getMetadata()));
    }

    @Override
    public DefaultFeatureType getType() {
        return this.types.parent;
    }

    @Deprecated
    public DefaultFeatureType getFeatureType(String name) throws IllegalNameException {
        return this.types.names.get(this, name);
    }

    @Override
    public final synchronized Stream<AbstractFeature> features(boolean parallel) throws DataStoreException {
        Reader r = this.reader;
        this.reader = null;
        if (r == null) {
            try {
                r = new Reader(this);
                this.version = r.initialize(false);
            }
            catch (DataStoreException e) {
                throw e;
            }
            catch (RuntimeException | URISyntaxException e) {
                throw new DataStoreContentException(e);
            }
            catch (Exception e) {
                throw new DataStoreException(e);
            }
        }
        Stream<AbstractFeature> features = StreamSupport.stream(r, false);
        return (Stream)features.onClose(r);
    }

    public synchronized void write(org.opengis.metadata.Metadata metadata, Stream<? extends AbstractFeature> features) throws DataStoreException {
        try {
            Reader r = this.reader;
            if (r != null) {
                this.reader = null;
                r.close();
            }
            try (Writer writer = new Writer(this, Metadata.castOrCopy(metadata, this.locale));){
                writer.writeStartDocument();
                if (features != null) {
                    features.forEachOrdered(writer);
                }
                writer.writeEndDocument();
            }
        }
        catch (BackingStoreException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DataStoreException) {
                throw (DataStoreException)cause;
            }
            throw new DataStoreException(e.getLocalizedMessage(), cause);
        }
        catch (Exception e2) {
            IOException e2;
            if (e2 instanceof UncheckedIOException) {
                e2 = ((UncheckedIOException)e2).getCause();
            }
            throw new DataStoreException(e2);
        }
    }

    @Override
    public synchronized void close() throws DataStoreException {
        Reader r = this.reader;
        this.reader = null;
        if (r != null) {
            try {
                r.close();
            }
            catch (Exception e) {
                DataStoreException ds = new DataStoreException(e);
                try {
                    super.close();
                }
                catch (DataStoreException s) {
                    ds.addSuppressed(s.getCause());
                }
                throw ds;
            }
        }
        super.close();
    }
}

