/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import org.apache.sis.internal.simple.SimpleMetadata;
import org.apache.sis.internal.storage.gpx.Bounds;
import org.apache.sis.internal.storage.gpx.Copyright;
import org.apache.sis.internal.storage.gpx.Link;
import org.apache.sis.internal.storage.gpx.Person;
import org.apache.sis.internal.storage.gpx.Store;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.io.TableAppender;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.metadata.iso.identification.DefaultKeywords;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.constraint.LegalConstraints;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.identification.Keywords;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

public final class Metadata
extends SimpleMetadata {
    Store store;
    public String creator;
    @XmlElement(name="name")
    public String name;
    @XmlElement(name="desc")
    public String description;
    @XmlElement(name="author")
    public Person author;
    @XmlElement(name="copyright")
    public Copyright copyright;
    @XmlElement(name="link")
    public List<Link> links;
    @XmlElement(name="time")
    public Date time;
    @XmlList
    @XmlElement(name="keywords")
    public List<String> keywords;
    @XmlElement(name="bounds")
    public Bounds bounds;
    private Format format;

    public Metadata() {
    }

    Metadata(org.opengis.metadata.Metadata md, Locale locale) {
        block0: for (Identification id : md.getIdentificationInfo()) {
            Citation ci = id.getCitation();
            if (ci != null) {
                if (this.name == null) {
                    this.name = Types.toString(ci.getTitle(), locale);
                }
                if (this.time == null) {
                    for (CitationDate citationDate : ci.getDates()) {
                        this.time = citationDate.getDate();
                        if (this.time == null) continue;
                        break;
                    }
                }
                if (ci instanceof DefaultCitation) {
                    for (OnlineResource onlineResource : ((DefaultCitation)ci).getOnlineResources()) {
                        this.links = Metadata.addIfNonNull(this.links, Link.castOrCopy(onlineResource, locale));
                    }
                }
            }
            if (this.description == null) {
                this.description = Types.toString(id.getAbstract(), locale);
            }
            for (ResponsibleParty responsibleParty : id.getPointOfContacts()) {
                Person p = Person.castOrCopy(responsibleParty, locale);
                if (p == null) continue;
                if (p.isCreator) {
                    if (this.creator != null) continue;
                    this.creator = p.name;
                    continue;
                }
                if (this.author != null) continue;
                this.author = p;
            }
            if (this.copyright == null) {
                for (Constraints constraints : id.getResourceConstraints()) {
                    if (!(constraints instanceof LegalConstraints)) continue;
                    this.copyright = Copyright.castOrCopy((LegalConstraints)constraints, locale);
                    if (this.copyright == null) continue;
                    break;
                }
            }
            for (Keywords keywords : id.getDescriptiveKeywords()) {
                for (InternationalString word : keywords.getKeywords()) {
                    this.keywords = Metadata.addIfNonNull(this.keywords, Types.toString(word, locale));
                }
            }
            if (this.bounds != null || !(id instanceof AbstractIdentification)) continue;
            for (Extent extent : ((AbstractIdentification)id).getExtents()) {
                this.bounds = Bounds.castOrCopy(Extents.getGeographicBoundingBox(extent));
                if (this.bounds == null) continue;
                continue block0;
            }
        }
    }

    public static Metadata castOrCopy(org.opengis.metadata.Metadata md, Locale locale) {
        return md == null || md instanceof Metadata ? (Metadata)md : new Metadata(md, locale);
    }

    @Override
    public InternationalString getTitle() {
        return this.name != null ? new SimpleInternationalString(this.name) : super.getTitle();
    }

    @Override
    public InternationalString getAbstract() {
        return this.description != null ? new SimpleInternationalString(this.description) : super.getAbstract();
    }

    @Override
    public Collection<Keywords> getDescriptiveKeywords() {
        if (this.keywords != null) {
            return Collections.singletonList(new DefaultKeywords(this.keywords.toArray(new String[this.keywords.size()])));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ResponsibleParty> getPointOfContacts() {
        if (this.creator != null) {
            Person p = new Person(this.creator);
            return this.author != null ? UnmodifiableArrayList.wrap(new ResponsibleParty[]{p, this.author}) : Collections.singletonList(this.author);
        }
        return this.author != null ? Collections.singletonList(this.author) : Collections.emptyList();
    }

    @Override
    public Collection<Constraints> getResourceConstraints() {
        return this.copyright != null ? Collections.singletonList(this.copyright) : Collections.emptyList();
    }

    @Override
    public Collection<Extent> getExtents() {
        return this.bounds != null ? Collections.singletonList(this.bounds) : Collections.emptyList();
    }

    @Override
    public Collection<ReferenceSystem> getReferenceSystemInfo() {
        return Collections.singletonList(CommonCRS.WGS84.geographic());
    }

    @Override
    public Collection<CitationDate> getDates() {
        if (this.time != null) {
            return Collections.singletonList(new DefaultCitationDate(this.time, DateType.CREATION));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ContentInformation> getContentInfo() {
        Store store = this.store;
        return store != null ? store.types.metadata : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Format> getResourceFormats() {
        Store store = this.store;
        if (store != null) {
            Format f;
            Store store2 = store;
            synchronized (store2) {
                f = this.format;
                if (f == null) {
                    this.format = f = store.getFormat();
                }
            }
            return Collections.singletonList(f);
        }
        return Collections.emptyList();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Metadata) {
            Metadata that = (Metadata)obj;
            return Objects.equals(this.creator, that.creator) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.author, that.author) && Objects.equals(this.copyright, that.copyright) && Objects.equals(this.links, that.links) && Objects.equals(this.time, that.time) && Objects.equals(this.keywords, that.keywords) && Objects.equals(this.bounds, that.bounds);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.creator, this.name, this.description, this.author, this.copyright, this.links, this.time, this.keywords, this.bounds);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("GPX metadata").append(System.lineSeparator());
        TableAppender table = new TableAppender(buffer);
        table.setMultiLinesCells(true);
        table.appendHorizontalSeparator();
        Metadata.append(table, "Creator", this.creator);
        Metadata.append(table, "Name", this.name);
        Metadata.append(table, "Description", this.description);
        Metadata.append(table, "Author", this.author);
        Metadata.append(table, "Copyright", this.copyright);
        Metadata.append(table, "Link(s)", this.links, System.lineSeparator());
        Metadata.append(table, "Time", this.time != null ? this.time.toInstant() : null);
        Metadata.append(table, "Keywords", this.keywords, " ");
        Metadata.append(table, "Bounds", this.bounds);
        table.appendHorizontalSeparator();
        try {
            table.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer.toString();
    }

    private static void append(TableAppender table, String label, Object value) {
        if (value != null) {
            table.append(label).append(':').nextColumn();
            table.append(value.toString()).nextLine();
        }
    }

    private static void append(TableAppender table, String label, List<?> values, String separator) {
        if (values != null && !values.isEmpty()) {
            table.append(label).append(':').nextColumn();
            int n = values.size();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    table.append(separator);
                }
                table.append(values.get(i).toString());
            }
            table.nextLine();
        }
    }

    static <T> List<T> addIfNonNull(List<T> list, T element) {
        if (element != null) {
            if (list == null) {
                list = new ArrayList<T>(4);
            }
            list.add(element);
        }
        return list;
    }
}

