/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.xml.MarshalContext;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.util.InternationalString;

public final class Link
implements OnlineResource {
    @XmlAttribute(name="href", required=true)
    public URI uri;
    @XmlElement(name="text")
    public String text;
    @XmlElement(name="type")
    public String type;

    public Link() {
    }

    public Link(URI uri) {
        this.uri = uri;
    }

    static Link valueOf(URI uri) {
        return uri != null ? new Link(uri) : null;
    }

    final void afterUnmarshal(Unmarshaller um, Object parent) {
        if (this.uri == null && this.text != null) {
            Context context = Context.current();
            try {
                Context.converter(context).toURI((MarshalContext)context, this.text);
            }
            catch (URISyntaxException e) {
                Context.warningOccured(context, Link.class, "afterUnmarshal", e, true);
            }
        }
    }

    private Link(OnlineResource r, Locale locale) {
        this.uri = r.getLinkage();
        this.text = r.getName();
    }

    public static Link castOrCopy(OnlineResource r, Locale locale) {
        return r == null || r instanceof Link ? (Link)r : new Link(r, locale);
    }

    public URI getLinkage() {
        return this.uri;
    }

    public String getProtocol() {
        return null;
    }

    public String getApplicationProfile() {
        return null;
    }

    public String getName() {
        return this.text;
    }

    public InternationalString getDescription() {
        return null;
    }

    public OnLineFunction getFunction() {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Link) {
            Link that = (Link)obj;
            return Objects.equals(this.uri, that.uri) && Objects.equals(this.text, that.text) && Objects.equals(this.type, that.type);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.text, this.type);
    }

    public String toString() {
        return this.uri != null ? this.uri.toString() : null;
    }
}

