/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.gpx;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.internal.feature.AttributeConvention;
import org.apache.sis.internal.feature.FeatureUtilities;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

final class GroupAsPolylineOperation
extends AbstractOperation {
    private static final long serialVersionUID = 7898989085371304159L;
    private static final ParameterDescriptorGroup EMPTY_PARAMS = FeatureUtilities.parameters("GroupPolylines", new ParameterDescriptor[0]);
    private final String association;
    private final DefaultAttributeType<?> result;

    GroupAsPolylineOperation(Map<String, ?> identification, String association, DefaultAttributeType<?> result) {
        super(identification);
        this.association = association;
        this.result = result;
    }

    static <G> DefaultAttributeType<? extends G> getResult(Geometries<G> geometries) {
        return new DefaultAttributeType<Object>(Collections.singletonMap("name", AttributeConvention.ENVELOPE_PROPERTY), geometries.polylineClass, 1, 1, null, new DefaultAttributeType[0]);
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    @Override
    public final DefaultAttributeType<?> getResult() {
        return this.result;
    }

    @Override
    public final Object apply(AbstractFeature feature, ParameterValueGroup parameters) {
        return new Result(feature, this.association, this.result);
    }

    private static final class Result<G>
    extends AbstractAttribute<G> {
        private static final long serialVersionUID = -8872834506769732436L;
        private final AbstractFeature feature;
        private final String association;
        private transient G geometry;

        Result(AbstractFeature feature, String association, DefaultAttributeType<G> result) {
            super(result);
            this.feature = feature;
            this.association = association;
        }

        @Override
        public G getValue() {
            if (this.geometry == null) {
                final Iterator it = ((Collection)this.feature.getPropertyValue(this.association)).iterator();
                Object geom = Geometries.mergePolylines(new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Object next() {
                        return ((AbstractFeature)it.next()).getPropertyValue("sis:geometry");
                    }
                });
                this.geometry = this.getType().getValueClass().cast(geom);
            }
            return this.geometry;
        }

        @Override
        public void setValue(G value) {
            throw new UnsupportedOperationException(Errors.format((short)153, AbstractAttribute.class));
        }
    }
}

