/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.ResourceOnFileSystem;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreResource;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.IllegalOpenParameterException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.WarningEvent;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

public abstract class URIDataStore
extends DataStore
implements StoreResource,
ResourceOnFileSystem {
    private final URI location;

    protected URIDataStore(DataStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.location = connector.getStorageAs(URI.class);
    }

    @Override
    public final DataStore getOriginator() {
        return this;
    }

    @Override
    public Path[] getComponentFiles() throws DataStoreException {
        Path path;
        if (this.location == null) {
            return new Path[0];
        }
        try {
            path = Paths.get(this.location);
        }
        catch (IllegalArgumentException | FileSystemNotFoundException e) {
            throw new DataStoreException(e);
        }
        return new Path[]{path};
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        return Optional.ofNullable(URIDataStore.parameters(this.provider, this.location));
    }

    public static ParameterValueGroup parameters(DataStoreProvider provider, URI location) {
        if (location == null || provider == null) {
            return null;
        }
        ParameterValueGroup pg = provider.getOpenParameters().createValue();
        pg.parameter("location").setValue((Object)location);
        return pg;
    }

    protected final void addTitleOrIdentifier(MetadataBuilder builder) {
        if (this.location != null) {
            builder.addTitleOrIdentifier(IOUtilities.filenameWithoutExtension(super.getDisplayName()), MetadataBuilder.Scope.ALL);
        }
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }

    public static abstract class Provider
    extends DataStoreProvider {
        public static final ParameterDescriptor<URI> LOCATION_PARAM;
        public static final ParameterDescriptor<Boolean> CREATE_PARAM;
        public static final ParameterDescriptor<Charset> ENCODING;
        private volatile ParameterDescriptorGroup openDescriptor;

        protected Provider() {
        }

        @Override
        public final ParameterDescriptorGroup getOpenParameters() {
            ParameterDescriptorGroup desc = this.openDescriptor;
            if (desc == null) {
                this.openDescriptor = desc = this.build((ParameterBuilder)new ParameterBuilder().addName(this.getShortName()));
            }
            return desc;
        }

        protected ParameterDescriptorGroup build(ParameterBuilder builder) {
            return builder.createGroup(new GeneralParameterDescriptor[]{LOCATION_PARAM});
        }

        public static ParameterDescriptorGroup descriptor(String name) {
            return ((ParameterBuilder)new ParameterBuilder().addName(name)).createGroup(new GeneralParameterDescriptor[]{LOCATION_PARAM});
        }

        public static StorageConnector connector(DataStoreProvider provider, ParameterValueGroup parameters) throws IllegalOpenParameterException {
            ParameterNotFoundException cause = null;
            if (parameters != null) {
                try {
                    Object location = parameters.parameter("location").getValue();
                    if (location != null) {
                        return new StorageConnector(location);
                    }
                }
                catch (ParameterNotFoundException e) {
                    cause = e;
                }
            }
            throw new IllegalOpenParameterException(Resources.format((short)27, provider.getShortName(), "location"), cause);
        }

        static {
            ParameterBuilder builder = new ParameterBuilder();
            ENCODING = ((ParameterBuilder)((ParameterBuilder)builder.addName("encoding")).setDescription((CharSequence)Resources.formatInternational((short)29))).create(Charset.class, null);
            CREATE_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName("create")).setDescription((CharSequence)Resources.formatInternational((short)51))).create(Boolean.class, null);
            LOCATION_PARAM = ((ParameterBuilder)((ParameterBuilder)builder.addName("location")).setDescription((CharSequence)Resources.formatInternational((short)31))).setRequired(true).create(URI.class, null);
        }
    }
}

