/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.metadata.Identifiers;
import org.apache.sis.internal.storage.Capability;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.StoreMetadata;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.WritableFeatureSet;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.identification.DataIdentification;
import org.opengis.metadata.identification.Identification;
import org.opengis.util.GenericName;

public final class StoreUtilities
extends Static {
    private StoreUtilities() {
    }

    public static String getFormatName(DataStoreProvider provider) {
        if (provider != null) {
            StoreMetadata md = provider.getClass().getAnnotation(StoreMetadata.class);
            if (md != null) {
                return md.formatName();
            }
            return provider.getShortName();
        }
        return null;
    }

    private static String getAnyIdentifier(Metadata metadata, boolean unicode) {
        String fallback = null;
        if (metadata != null) {
            for (Identification md : metadata.getIdentificationInfo()) {
                String id = Identifiers.getIdentifier(md.getCitation(), unicode);
                if (id == null) continue;
                if (md instanceof DataIdentification) {
                    return id;
                }
                if (fallback != null) continue;
                fallback = id;
            }
        }
        return fallback;
    }

    public static String getLabel(Resource resource) throws DataStoreException {
        String title = null;
        if (resource instanceof DataStore) {
            title = ((DataStore)resource).getDisplayName();
        }
        if (title == null) {
            Optional<GenericName> identifier = resource.getIdentifier();
            if (identifier.isPresent()) {
                title = identifier.get().toString();
            } else {
                title = StoreUtilities.getAnyIdentifier(resource.getMetadata(), false);
                if (title == null) {
                    title = Classes.getShortName(StoreUtilities.getInterface(resource.getClass()));
                }
            }
        }
        return title;
    }

    public static Envelope getEnvelope(Metadata metadata) {
        GeneralEnvelope bounds = null;
        if (metadata != null) {
            for (Identification identification : metadata.getIdentificationInfo()) {
                if (!(identification instanceof AbstractIdentification)) continue;
                for (Extent extent : ((AbstractIdentification)identification).getExtents()) {
                    for (GeographicExtent ge : extent.getGeographicElements()) {
                        if (!(ge instanceof GeographicBoundingBox)) continue;
                        GeneralEnvelope env = new GeneralEnvelope((GeographicBoundingBox)ge);
                        if (bounds == null) {
                            bounds = env;
                            continue;
                        }
                        bounds.add(env);
                    }
                }
            }
        }
        return bounds;
    }

    public static Class<? extends Resource> getInterface(Class<? extends Resource> implementation) {
        Class<Resource>[] types = Classes.getLeafInterfaces(implementation, Resource.class);
        Class<Resource> type = null;
        int i = types.length;
        while (--i >= 0 && !FeatureSet.class.isAssignableFrom(type = types[i])) {
        }
        return type;
    }

    public static String[] getFileSuffixes(Class<? extends DataStoreProvider> provider) {
        StoreMetadata md;
        if (provider != null && (md = provider.getAnnotation(StoreMetadata.class)) != null) {
            return md.fileSuffixes();
        }
        return CharSequences.EMPTY_ARRAY;
    }

    public static Boolean canWrite(Class<? extends DataStoreProvider> provider) {
        StoreMetadata md;
        if (provider != null && (md = provider.getAnnotation(StoreMetadata.class)) != null) {
            for (Capability c : md.capabilities()) {
                if (!Capability.WRITE.equals((Object)c)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public static EnumSet<StandardOpenOption> toStandardOptions(OpenOption[] options) {
        EnumSet<StandardOpenOption> set = EnumSet.noneOf(StandardOpenOption.class);
        if (options != null) {
            for (OpenOption op : options) {
                if (!(op instanceof StandardOpenOption)) continue;
                switch ((StandardOpenOption)op) {
                    case CREATE_NEW: {
                        set.add(StandardOpenOption.CREATE_NEW);
                    }
                    case TRUNCATE_EXISTING: {
                        set.add(StandardOpenOption.TRUNCATE_EXISTING);
                    }
                    case CREATE: {
                        set.add(StandardOpenOption.CREATE);
                    }
                    case APPEND: 
                    case WRITE: {
                        set.add(StandardOpenOption.WRITE);
                    }
                }
            }
            if (set.contains(StandardOpenOption.CREATE_NEW)) {
                set.remove(StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        return set;
    }

    public static DataStoreProvider providerByFormatName(String format) throws UnsupportedStorageException {
        for (DataStoreProvider provider : DataStores.providers()) {
            if (!format.equalsIgnoreCase(StoreUtilities.getFormatName(provider))) continue;
            return provider;
        }
        throw new UnsupportedStorageException(Errors.format((short)181, format));
    }

    public static void copy(FeatureSet source, WritableFeatureSet target) throws DataStoreException {
        target.updateType(source.getType());
        try (Stream<AbstractFeature> stream = source.features(false);){
            target.add(stream.iterator());
        }
    }

    public static String resourceNotFound(DataStore store, String identifier) {
        return Resources.forLocale(store.getLocale()).getString((short)24, store.getDisplayName(), identifier);
    }
}

