/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.distribution.Format;

public abstract class DocumentedStoreProvider
extends URIDataStore.Provider {
    private final String name;
    private volatile boolean logged;

    protected DocumentedStoreProvider(String name) {
        this.name = name;
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public final Format getFormat() {
        return this.getFormat(null);
    }

    public final Format getFormat(StoreListeners listeners) {
        if (this.name != null) {
            try {
                return MetadataSource.getProvided().lookup(Format.class, this.name);
            }
            catch (MetadataStoreException e) {
                Level level;
                if (listeners != null) {
                    listeners.warning(e);
                }
                if (!this.logged) {
                    this.logged = true;
                    level = Level.WARNING;
                } else {
                    level = Level.FINE;
                }
                LogRecord record = Resources.forLocale(null).getLogRecord(level, (short)39, this.getShortName(), e.getLocalizedMessage());
                record.setLoggerName("org.apache.sis.storage");
                Logging.log(this.getClass(), "getFormat", record);
            }
        }
        return super.getFormat();
    }
}

