/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Optional;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.event.WarningEvent;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;

public class AbstractResource
extends StoreListeners
implements Resource {
    private Metadata metadata;

    public AbstractResource(StoreListeners parent) {
        super(parent, (Resource)null);
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        return Optional.empty();
    }

    public Optional<Envelope> getEnvelope() throws DataStoreException {
        return Optional.empty();
    }

    @Override
    public final synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            MetadataBuilder builder = new MetadataBuilder();
            this.createMetadata(builder);
            this.metadata = builder.build(true);
        }
        return this.metadata;
    }

    protected void createMetadata(MetadataBuilder metadata) throws DataStoreException {
        this.getIdentifier().ifPresent(name -> metadata.addTitle((CharSequence)name.toInternationalString()));
        this.getEnvelope().ifPresent(envelope -> {
            try {
                metadata.addExtent((Envelope)envelope);
            }
            catch (UnsupportedOperationException | TransformException e) {
                this.warning((Exception)e);
            }
        });
    }

    protected synchronized void clearCache() {
        this.metadata = null;
    }

    @Override
    public <T extends StoreEvent> void addListener(Class<T> eventType, StoreListener<? super T> listener) {
        if (listener == null || eventType == null || eventType.isAssignableFrom(WarningEvent.class)) {
            super.addListener(eventType, listener);
        }
    }
}

