/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.util.Optional;
import java.util.OptionalLong;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.storage.AbstractResource;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.event.StoreListeners;
import org.opengis.util.GenericName;

public abstract class AbstractFeatureSet
extends AbstractResource
implements FeatureSet {
    protected AbstractFeatureSet(StoreListeners parent) {
        super(parent);
    }

    @Override
    public Optional<GenericName> getIdentifier() throws DataStoreException {
        DefaultFeatureType type = this.getType();
        return type != null ? Optional.of(type.getName()) : Optional.empty();
    }

    protected OptionalLong getFeatureCount() {
        return OptionalLong.empty();
    }

    @Override
    protected void createMetadata(MetadataBuilder metadata) throws DataStoreException {
        super.createMetadata(metadata);
        metadata.addFeatureType(this.getType(), this.getFeatureCount().orElse(-1L));
    }
}

