/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import org.apache.sis.setup.GeometryLibrary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class SpatialFunctions {
    private final boolean isByteUnsigned;
    final GeometryLibrary library;

    SpatialFunctions(DatabaseMetaData metadata) throws SQLException {
        boolean unsigned = true;
        try (ResultSet reflect = metadata.getTypeInfo();){
            while (reflect.next() && (reflect.getInt("DATA_TYPE") != -6 || !(unsigned = reflect.getBoolean("UNSIGNED_ATTRIBUTE")))) {
            }
        }
        this.isByteUnsigned = unsigned;
        this.library = null;
    }

    protected Class<?> toJavaType(int sqlType, String sqlTypeName) {
        switch (sqlType) {
            case -7: 
            case 16: {
                return Boolean.class;
            }
            case -6: {
                if (!this.isByteUnsigned) {
                    return Byte.class;
                }
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 91: {
                return LocalDate.class;
            }
            case 92: {
                return LocalTime.class;
            }
            case 93: {
                return LocalDateTime.class;
            }
            case 2013: {
                return OffsetTime.class;
            }
            case 2014: {
                return OffsetDateTime.class;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case 2003: {
                return Object[].class;
            }
            case 1111: 
            case 2000: {
                return Object.class;
            }
        }
        return null;
    }

    protected CoordinateReferenceSystem createGeometryCRS(ResultSet reflect) throws SQLException {
        return null;
    }
}

