/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.KeyConstants;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.InternationalString;

public final class Resources
extends IndexedResourceBundle {
    public Resources(URL resources) {
        super(resources);
    }

    @Override
    protected KeyConstants getKeyConstants() {
        return Keys.INSTANCE;
    }

    public static Resources forLocale(Locale locale) throws MissingResourceException {
        return Resources.getBundle(Resources.class, locale);
    }

    public static String format(short key) throws MissingResourceException {
        return Resources.forLocale(null).getString(key);
    }

    public static String format(short key, Object arg0) throws MissingResourceException {
        return Resources.forLocale(null).getString(key, arg0);
    }

    public static String format(short key, Object arg0, Object arg1) throws MissingResourceException {
        return Resources.forLocale(null).getString(key, arg0, arg1);
    }

    public static InternationalString formatInternational(short key) {
        return new International(key);
    }

    public static ResourceInternationalString formatInternational(short key, Object ... args) {
        return new International(key, args);
    }

    private static final class International
    extends ResourceInternationalString {
        private static final long serialVersionUID = 7325356372249131588L;

        International(short key) {
            super(key);
        }

        International(short key, Object args) {
            super(key, args);
        }

        @Override
        protected KeyConstants getKeyConstants() {
            return Keys.INSTANCE;
        }

        @Override
        protected IndexedResourceBundle getBundle(Locale locale) {
            return Resources.forLocale(locale);
        }
    }

    public static final class Keys
    extends KeyConstants {
        static final Keys INSTANCE = new Keys();
        public static final short DataSource = 1;
        public static final short DuplicatedColumn_1 = 5;
        public static final short IllegalQualifiedName_1 = 3;
        public static final short InternalError = 6;
        public static final short MalformedForeignerKey_2 = 7;
        public static final short QualifiedTableNames = 2;
        public static final short UnknownType_1 = 4;

        private Keys() {
        }
    }
}

