/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.metadata.sql.SQLBuilder;
import org.apache.sis.internal.sql.feature.Relation;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.sql.feature.Table;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.WeakValueHashMap;

final class Features
implements Spliterator<AbstractFeature>,
Runnable {
    private static final Features[] EMPTY = new Features[0];
    private final DefaultFeatureType featureType;
    private final String[] attributeNames;
    private final String[] associationNames;
    private final String deferredAssociation;
    private final Features[] dependencies;
    private final int importCount;
    private final int[][] foreignerKeyIndices;
    private final PreparedStatement statement;
    private ResultSet result;
    private final WeakValueHashMap<?, Object> instances;
    private final Class<?> keyComponentClass;
    private final long estimatedSize;

    Features(Table table, Connection connection, String[] attributeNames, String[] attributeColumns, Relation[] importedKeys, Relation[] exportedKeys, List<Relation> following, Relation noFollow) throws SQLException, InternalDataStoreException {
        int exportCount;
        this.featureType = table.featureType;
        this.attributeNames = attributeNames;
        DatabaseMetaData metadata = connection.getMetaData();
        this.estimatedSize = following.isEmpty() ? table.countRows(metadata, true) : 0L;
        SQLBuilder sql = new SQLBuilder(metadata, true).append("SELECT");
        HashMap<String, Integer> columnIndices = new HashMap<String, Integer>();
        for (String column : attributeColumns) {
            Features.appendColumn(sql, column, columnIndices);
        }
        int importCount = importedKeys != null ? importedKeys.length : 0;
        int totalCount = importCount + (exportCount = exportedKeys != null ? exportedKeys.length : 0);
        if (totalCount == 0) {
            this.dependencies = EMPTY;
            this.associationNames = null;
            this.foreignerKeyIndices = null;
            this.deferredAssociation = null;
        } else {
            String deferredAssociation = null;
            Features[] dependencies = new Features[totalCount];
            String[] associationNames = new String[totalCount];
            int[][] foreignerKeyIndices = new int[totalCount][];
            if (importCount != 0) {
                importCount = 0;
                for (Relation dependency : importedKeys) {
                    if (dependency != noFollow) {
                        dependency.startFollowing(following);
                        associationNames[importCount] = dependency.propertyName;
                        foreignerKeyIndices[importCount] = Features.getColumnIndices(sql, dependency.getForeignerKeys(), columnIndices);
                        dependencies[importCount] = dependency.getSearchTable().features(connection, following, noFollow);
                        dependency.endFollowing(following);
                        ++importCount;
                        continue;
                    }
                    deferredAssociation = dependency.propertyName;
                }
            }
            if (exportCount != 0) {
                int i = importCount;
                for (Relation dependency : exportedKeys) {
                    dependency.startFollowing(following);
                    Table foreigner = dependency.getSearchTable();
                    Relation inverse = foreigner.getInverseOf(dependency, table.name);
                    associationNames[i] = dependency.propertyName;
                    foreignerKeyIndices[i] = Features.getColumnIndices(sql, dependency.getForeignerKeys(), columnIndices);
                    dependencies[i] = foreigner.features(connection, following, inverse);
                    dependency.endFollowing(following);
                    ++i;
                }
            }
            totalCount = importCount + exportCount;
            this.dependencies = ArraysExt.resize(dependencies, totalCount);
            this.associationNames = ArraysExt.resize(associationNames, totalCount);
            this.foreignerKeyIndices = (int[][])ArraysExt.resize(foreignerKeyIndices, totalCount);
            this.deferredAssociation = deferredAssociation;
        }
        this.importCount = importCount;
        sql.append(" FROM ").appendIdentifier(table.name.catalog, table.name.schema, table.name.table);
        if (following.isEmpty()) {
            this.statement = null;
            this.instances = null;
            this.keyComponentClass = null;
            this.result = connection.createStatement().executeQuery(sql.toString());
        } else {
            Relation componentOf = following.get(following.size() - 1);
            String separator = " WHERE ";
            for (String primaryKey : componentOf.getSearchColumns()) {
                sql.append(separator).appendIdentifier(primaryKey).append("=?");
                separator = " AND ";
            }
            this.statement = connection.prepareStatement(sql.toString());
            if (componentOf.useFullKey()) {
                this.instances = table.instanceForPrimaryKeys();
                this.keyComponentClass = table.primaryKeyClass.getComponentType();
            } else {
                this.instances = new WeakValueHashMap(Object.class);
                this.keyComponentClass = Object.class;
            }
        }
    }

    private static int appendColumn(SQLBuilder sql, String column, Map<String, Integer> columnIndices) throws InternalDataStoreException {
        int columnCount = columnIndices.size();
        if (columnCount != 0) {
            sql.append(',');
        }
        sql.append(' ').appendIdentifier(column);
        if (columnIndices.put(column, ++columnCount) == null) {
            return columnCount;
        }
        throw new InternalDataStoreException(Resources.format((short)5, column));
    }

    private static int[] getColumnIndices(SQLBuilder sql, Collection<String> columns, Map<String, Integer> columnIndices) throws InternalDataStoreException {
        int i = 0;
        int[] indices = new int[columns.size()];
        for (String column : columns) {
            Integer pos = columnIndices.get(column);
            indices[i++] = pos != null ? pos : Features.appendColumn(sql, column, columnIndices);
        }
        return indices;
    }

    private Object identifierArray(int columnCount) {
        return columnCount > 1 ? Array.newInstance(this.keyComponentClass, columnCount) : null;
    }

    @Override
    public int characteristics() {
        return 256;
    }

    @Override
    public long estimateSize() {
        return this.estimatedSize > 0L ? this.estimatedSize : Long.MAX_VALUE;
    }

    @Override
    public Spliterator<AbstractFeature> trySplit() {
        return null;
    }

    @Override
    public boolean tryAdvance(Consumer<? super AbstractFeature> action) {
        try {
            return this.fetch(action, false);
        }
        catch (SQLException e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super AbstractFeature> action) {
        try {
            this.fetch(action, true);
        }
        catch (SQLException e) {
            throw new BackingStoreException(e);
        }
    }

    private boolean fetch(Consumer<? super AbstractFeature> action, boolean all) throws SQLException {
        while (this.result.next()) {
            int i;
            AbstractFeature feature = this.featureType.newInstance();
            for (i = 0; i < this.attributeNames.length; ++i) {
                Object value = this.result.getObject(i + 1);
                if (this.result.wasNull()) continue;
                feature.setPropertyValue(this.attributeNames[i], value);
            }
            for (i = 0; i < this.dependencies.length; ++i) {
                Object value;
                Features dependency = this.dependencies[i];
                int[] columnIndices = this.foreignerKeyIndices[i];
                if (i < this.importCount) {
                    Object key = null;
                    Object keys = dependency.identifierArray(columnIndices.length);
                    int p = 0;
                    while (p < columnIndices.length) {
                        key = this.result.getObject(columnIndices[p]);
                        if (keys != null) {
                            Array.set(keys, p, key);
                        }
                        dependency.statement.setObject(++p, key);
                    }
                    if (keys != null) {
                        key = keys;
                    }
                    value = dependency.fetchReferenced(key, null);
                } else {
                    int p = 0;
                    while (p < columnIndices.length) {
                        Object k = this.result.getObject(columnIndices[p]);
                        dependency.statement.setObject(++p, k);
                    }
                    value = dependency.fetchReferenced(null, feature);
                }
                feature.setPropertyValue(this.associationNames[i], value);
            }
            action.accept(feature);
            if (all) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fetchReferenced(Object key, AbstractFeature owner) throws SQLException {
        ArrayList previous;
        ArrayList feature;
        Object existing;
        if (key != null && (existing = this.instances.get(key)) != null) {
            return existing;
        }
        ArrayList features = new ArrayList();
        try (ResultSet r = this.statement.executeQuery();){
            this.result = r;
            this.fetch(features::add, true);
        }
        finally {
            this.result = null;
        }
        if (owner != null && this.deferredAssociation != null) {
            for (AbstractFeature feature2 : features) {
                feature2.setPropertyValue(this.deferredAssociation, owner);
            }
        }
        switch (features.size()) {
            case 0: {
                feature = null;
                break;
            }
            case 1: {
                feature = features.get(0);
                break;
            }
            default: {
                feature = features;
            }
        }
        if (key != null && (previous = this.instances.putIfAbsent(key, feature)) != null) {
            feature = previous;
        }
        return feature;
    }

    private void close() throws SQLException {
        ResultSet r;
        if (this.statement != null) {
            this.statement.close();
        }
        if ((r = this.result) != null) {
            this.result = null;
            Statement s = r.getStatement();
            try (Connection c = s.getConnection();){
                r.close();
                s.close();
                for (Features dependency : this.dependencies) {
                    dependency.close();
                }
            }
        }
    }

    @Override
    public void run() {
        try {
            this.close();
        }
        catch (SQLException e) {
            throw new BackingStoreException(e);
        }
    }
}

