/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.sql.feature;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.sql.DataSource;
import org.apache.sis.internal.metadata.sql.Dialect;
import org.apache.sis.internal.metadata.sql.SQLUtilities;
import org.apache.sis.internal.sql.feature.Resources;
import org.apache.sis.internal.sql.feature.SpatialFunctions;
import org.apache.sis.internal.sql.feature.Table;
import org.apache.sis.internal.sql.feature.TableReference;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.sql.SQLStore;
import org.apache.sis.util.resources.ResourceInternationalString;
import org.opengis.util.GenericName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

final class Analyzer {
    final DataSource source;
    final DatabaseMetaData metadata;
    final SpatialFunctions functions;
    final NameFactory nameFactory;
    private final Map<String, String> strings;
    private final String escape;
    private final Set<String> ignoredTables;
    private final Map<GenericName, Table> tables;
    private final Set<ResourceInternationalString> warnings;
    final StoreListeners listeners;
    final Locale locale;
    private transient String catalog;
    private transient String schema;
    private transient NameSpace namespace;

    Analyzer(DataSource source, DatabaseMetaData metadata, StoreListeners listeners, Locale locale) throws SQLException {
        this.source = source;
        this.metadata = metadata;
        this.listeners = listeners;
        this.locale = locale;
        this.strings = new HashMap<String, String>();
        this.escape = metadata.getSearchStringEscape();
        this.functions = new SpatialFunctions(metadata);
        this.nameFactory = DefaultFactories.forBuildin(NameFactory.class);
        String crs = "SPATIAL_REF_SYS";
        String geom = "GEOMETRY_COLUMNS";
        if (metadata.storesLowerCaseIdentifiers()) {
            crs = crs.toLowerCase(Locale.US).intern();
            geom = geom.toLowerCase(Locale.US).intern();
        }
        this.ignoredTables = new HashSet<String>(4);
        this.ignoredTables.add(crs);
        this.ignoredTables.add(geom);
        Dialect dialect = Dialect.guess(metadata);
        if (dialect == Dialect.POSTGRESQL) {
            this.ignoredTables.add("geography_columns");
            this.ignoredTables.add("raster_columns");
            this.ignoredTables.add("raster_overviews");
        }
        this.tables = new HashMap<GenericName, Table>();
        this.warnings = new LinkedHashSet<ResourceInternationalString>();
    }

    final String escape(String pattern) {
        return SQLUtilities.escape(pattern, this.escape);
    }

    final String getUniqueString(ResultSet reflect, String column) throws SQLException {
        String p;
        String value = reflect.getString(column);
        if (value != null && (p = this.strings.putIfAbsent(value, value)) != null) {
            value = p;
        }
        return value;
    }

    final boolean isIgnoredTable(String name) {
        return this.ignoredTables.contains(name);
    }

    final NameSpace namespace(String catalog, String schema) {
        if (!Objects.equals(this.schema, schema) || !Objects.equals(this.catalog, catalog)) {
            if (schema != null) {
                Object name = catalog == null ? this.nameFactory.createLocalName(null, (CharSequence)schema) : this.nameFactory.createGenericName(null, new CharSequence[]{catalog, schema});
                this.namespace = this.nameFactory.createNameSpace((GenericName)name, Collections.singletonMap("separator", "."));
            } else {
                this.namespace = null;
            }
            this.catalog = catalog;
            this.schema = schema;
        }
        return this.namespace;
    }

    final Table table(TableReference id, GenericName name, TableReference importedBy) throws SQLException, DataStoreException {
        Table table = this.tables.get(name);
        if (table == null && !this.tables.containsKey(name)) {
            this.tables.put(name, null);
            table = new Table(this, id, importedBy);
            if (this.tables.put(name, table) != null) {
                throw new InternalDataStoreException(this.internalError());
            }
        }
        return table;
    }

    final String internalError() {
        return Resources.forLocale(this.locale).getString((short)6);
    }

    final void warning(short key, Object argument) {
        this.warnings.add(Resources.formatInternational(key, argument));
    }

    final Collection<Table> finish() throws DataStoreException {
        for (Table table : this.tables.values()) {
            table.setDeferredSearchTables(this, this.tables);
        }
        for (ResourceInternationalString warning : this.warnings) {
            LogRecord record = warning.toLogRecord(Level.WARNING);
            record.setSourceClassName(SQLStore.class.getName());
            record.setSourceMethodName("components");
            this.listeners.warning(record);
        }
        return this.tables.values();
    }
}

