/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.AbstractProvider;
import org.apache.sis.internal.referencing.provider.DatumShiftGridCompressed;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.referencing.provider.DatumShiftGridLoader;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.transform.InterpolatedTransform;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

@XmlTransient
public final class NTv2
extends AbstractProvider {
    private static final long serialVersionUID = -4027618007780159180L;
    private static final ParameterDescriptor<Path> FILE;
    public static final ParameterDescriptorGroup PARAMETERS;

    public NTv2() {
        super(2, 2, PARAMETERS);
    }

    public Class<Transformation> getOperationType() {
        return Transformation.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws ParameterNotFoundException, FactoryException {
        Parameters pg = Parameters.castOrWrap(values);
        return InterpolatedTransform.createGeodeticTransformation(factory, NTv2.getOrLoad(pg.getMandatoryValue(FILE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatumShiftGridFile<Angle, Angle> getOrLoad(Path file) throws FactoryException {
        DatumShiftGridFile<Object, Object> grid;
        block12: {
            Path resolved = DataDirectory.DATUM_CHANGES.resolve(file).toAbsolutePath();
            grid = DatumShiftGridFile.CACHE.peek(resolved);
            if (grid == null) {
                Cache.Handler<DatumShiftGridFile<?, ?>> handler = DatumShiftGridFile.CACHE.lock(resolved);
                try {
                    grid = handler.peek();
                    if (grid != null) break block12;
                    try (SeekableByteChannel in = Files.newByteChannel(resolved, new OpenOption[0]);){
                        DatumShiftGridLoader.log(NTv2.class, file);
                        Loader loader = new Loader(in, file);
                        grid = loader.readGrid();
                        loader.reportWarnings();
                    }
                    catch (IOException | RuntimeException | NoninvertibleTransformException e) {
                        throw DatumShiftGridLoader.canNotLoad("NTv2", file, (Exception)e);
                    }
                    grid = grid.useSharedData();
                }
                finally {
                    handler.putAndUnlock(grid);
                }
            }
        }
        return grid.castTo(Angle.class, Angle.class);
    }

    static {
        ParameterBuilder builder = NTv2.builder();
        FILE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8656")).addName("Latitude and longitude difference file")).create(Path.class, null);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9615")).addName("NTv2")).createGroup(new GeneralParameterDescriptor[]{FILE});
    }

    private static final class Loader
    extends DatumShiftGridLoader {
        private static final int RECORD_LENGTH = 16;
        private static final int KEY_LENGTH = 8;
        private static final int STRING_TYPE = 0;
        private static final int INTEGER_TYPE = 1;
        private static final int DOUBLE_TYPE = 2;
        private static final Map<String, Integer> TYPES;
        private final Map<String, Object> header = new LinkedHashMap<String, Object>();
        private boolean hasUnrecognized;
        private int remainingGrids;

        Loader(ReadableByteChannel channel, Path file) throws IOException, FactoryException {
            super(channel, ByteBuffer.allocate(4096), file);
            this.ensureBufferContains(16);
            if (Loader.isLittleEndian(this.buffer.getInt(8))) {
                this.buffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            this.readHeader(11, "NUM_OREC");
            this.remainingGrids = (Integer)this.get("NUM_FILE");
            if (this.remainingGrids < 1) {
                throw new FactoryException(Errors.format((short)144, "NUM_FILE", this.remainingGrids));
            }
        }

        final DatumShiftGridFile<Angle, Angle> readGrid() throws IOException, FactoryException, NoninvertibleTransformException {
            double precision;
            Unit<Angle> unit;
            if (--this.remainingGrids < 0) {
                throw new FactoryException(Errors.format((short)12, this.file));
            }
            Object[] overviewKeys = this.header.keySet().toArray();
            this.readHeader((Integer)this.get("NUM_SREC"), "NUM_SREC");
            String name = (String)this.get("GS_TYPE");
            if (name.equalsIgnoreCase("SECONDS")) {
                unit = Units.ARC_SECOND;
                precision = 1.0E-4;
            } else if (name.equalsIgnoreCase("MINUTES")) {
                unit = Units.ARC_MINUTE;
                precision = 1.6666666666666667E-6;
            } else if (name.equalsIgnoreCase("DEGREES")) {
                unit = Units.DEGREE;
                precision = 2.777777777777778E-8;
            } else {
                throw new FactoryException(Errors.format((short)144, "GS_TYPE", name));
            }
            double ymin = (Double)this.get("S_LAT");
            double ymax = (Double)this.get("N_LAT");
            double xmin = (Double)this.get("E_LONG");
            double xmax = (Double)this.get("W_LONG");
            double dy = (Double)this.get("LAT_INC");
            double dx = (Double)this.get("LONG_INC");
            Integer declared = (Integer)this.header.get("GS_COUNT");
            int width = Math.toIntExact(Math.round((xmax - xmin) / dx + 1.0));
            int height = Math.toIntExact(Math.round((ymax - ymin) / dy + 1.0));
            int count = Math.multiplyExact(width, height);
            if (declared != null && count != declared) {
                throw new FactoryException(Errors.format((short)144, "GS_COUNT", declared));
            }
            DatumShiftGridFile.Float<Angle, Angle> grid = new DatumShiftGridFile.Float<Angle, Angle>(2, unit, unit, true, -xmin, ymin, -dx, dy, width, height, PARAMETERS, this.file);
            float[] tx = grid.offsets[0];
            float[] ty = grid.offsets[1];
            for (int i = 0; i < count; ++i) {
                this.ensureBufferContains(16);
                ty[i] = (float)((double)this.buffer.getFloat() / dy);
                tx[i] = (float)((double)this.buffer.getFloat() / dx);
                double accuracy = Math.min((double)this.buffer.getFloat() / dy, (double)this.buffer.getFloat() / dx);
                if (!(accuracy > 0.0) || accuracy >= grid.accuracy) continue;
                grid.accuracy = accuracy;
            }
            double size = Math.max(dx, dy);
            if (Double.isNaN(grid.accuracy)) {
                grid.accuracy = Units.DEGREE.getConverterTo(unit).convert(8.999280057595393E-8) / size;
            }
            this.header.keySet().retainAll(Arrays.asList(overviewKeys));
            return DatumShiftGridCompressed.compress(grid, null, precision / size);
        }

        private static boolean isLittleEndian(int n) {
            return Integer.compareUnsigned(n, Integer.reverseBytes(n)) > 0;
        }

        private String readString(int position, int length) {
            byte[] array = this.buffer.array();
            while (length > position && array[position + length - 1] <= 32) {
                --length;
            }
            return new String(array, position, length, StandardCharsets.US_ASCII).trim();
        }

        private void readHeader(int numRecords, String numkey) throws IOException, FactoryException {
            int position = this.buffer.position();
            for (int i = 0; i < numRecords; ++i) {
                Object value;
                this.ensureBufferContains(16);
                String key = this.readString(position, 8).toUpperCase(Locale.US);
                position += 8;
                Integer type = TYPES.get(key);
                if (type == null) {
                    value = null;
                    this.hasUnrecognized = true;
                } else {
                    switch (type) {
                        case 0: {
                            value = this.readString(position, 8);
                            break;
                        }
                        case 1: {
                            int n = this.buffer.getInt(position);
                            if (key.equals(numkey)) {
                                numRecords = n;
                            }
                            value = n;
                            break;
                        }
                        case 2: {
                            value = this.buffer.getDouble(position);
                            break;
                        }
                        default: {
                            throw new AssertionError(type);
                        }
                    }
                }
                Object old = this.header.put(key, value);
                if (old != null && !old.equals(value)) {
                    throw new FactoryException(Errors.format((short)75, key));
                }
                this.buffer.position(position += 8);
            }
        }

        private Object get(String key) throws FactoryException {
            Object value = this.header.get(key);
            if (value != null) {
                return value;
            }
            throw new FactoryException(Errors.format((short)120, this.file, key));
        }

        void reportWarnings() {
            if (this.hasUnrecognized) {
                StringBuilder keywords = new StringBuilder();
                for (Map.Entry<String, Object> entry : this.header.entrySet()) {
                    if (entry.getValue() != null) continue;
                    if (keywords.length() != 0) {
                        keywords.append(", ");
                    }
                    keywords.append(entry.getKey());
                }
                LogRecord record = Messages.getResources(null).getLogRecord(Level.WARNING, (short)30, this.file, keywords.toString());
                record.setLoggerName("org.apache.sis.referencing.operation");
                Logging.log(NTv2.class, "createMathTransform", record);
            }
        }

        static {
            HashMap<String, Integer> types = new HashMap<String, Integer>(32);
            Integer string = 0;
            Integer integer = 1;
            Integer real = 2;
            types.put("NUM_OREC", integer);
            types.put("NUM_SREC", integer);
            types.put("NUM_FILE", integer);
            types.put("GS_TYPE", string);
            types.put("VERSION", string);
            types.put("SYSTEM_F", string);
            types.put("SYSTEM_T", string);
            types.put("MAJOR_F", real);
            types.put("MINOR_F", real);
            types.put("MAJOR_T", real);
            types.put("MINOR_T", real);
            types.put("SUB_NAME", string);
            types.put("PARENT", string);
            types.put("CREATED", string);
            types.put("UPDATED", string);
            types.put("S_LAT", real);
            types.put("N_LAT", real);
            types.put("E_LONG", real);
            types.put("W_LONG", real);
            types.put("LAT_INC", real);
            types.put("LONG_INC", real);
            types.put("GS_COUNT", integer);
            TYPES = types;
        }
    }
}

