/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.referencing.provider.FranceGeocentricInterpolation;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.transform.InterpolatedMolodenskyTransform;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class MolodenskyInterpolation
extends FranceGeocentricInterpolation {
    private static final long serialVersionUID = 4265894749866901286L;

    public MolodenskyInterpolation() {
        super(2, 2, ((ParameterBuilder)((ParameterBuilder)MolodenskyInterpolation.builder().setCodeSpace(null, "SIS")).addName("Molodensky interpolation")).createGroupWithSameParameters(PARAMETERS), new MolodenskyInterpolation[4]);
        ParameterDescriptorGroup parameters = super.getParameters();
        this.redimensioned[0] = this;
        this.redimensioned[1] = new MolodenskyInterpolation(2, 3, parameters, this.redimensioned);
        this.redimensioned[2] = new MolodenskyInterpolation(3, 2, parameters, this.redimensioned);
        this.redimensioned[3] = new MolodenskyInterpolation(3, 3, parameters, this.redimensioned);
    }

    private MolodenskyInterpolation(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters, GeodeticOperation[] redimensioned) {
        super(sourceDimensions, targetDimensions, parameters, redimensioned);
    }

    @Override
    MathTransform createGeodeticTransformation(MathTransformFactory factory, Ellipsoid source, Ellipsoid target, boolean withHeights, DatumShiftGridFile<Angle, Length> grid) throws FactoryException {
        return InterpolatedMolodenskyTransform.createGeodeticTransformation(factory, source, withHeights, target, withHeights, grid);
    }
}

