/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

@XmlTransient
class GeographicRedimension
extends GeodeticOperation {
    private static final long serialVersionUID = -3021902514274756742L;

    GeographicRedimension(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters, GeodeticOperation[] redimensioned) {
        super(sourceDimensions, targetDimensions, parameters, redimensioned);
    }

    GeographicRedimension(int dimension, GeodeticOperation[] redimensioned) {
        super(dimension, dimension, ((ParameterBuilder)((ParameterBuilder)GeographicRedimension.builder().setCodeSpace(Citations.SIS, "SIS")).addName("Identity " + dimension + 'D')).createGroup(new GeneralParameterDescriptor[0]), redimensioned);
    }

    public final Class<Conversion> getOperationType() {
        return Conversion.class;
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws FactoryException {
        return factory.createAffineTransform((Matrix)Matrices.createDiagonal(this.getTargetDimensions() + 1, this.getSourceDimensions() + 1));
    }
}

