/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.provider.DatumShiftGridCompressed;
import org.apache.sis.internal.referencing.provider.DatumShiftGridFile;
import org.apache.sis.internal.referencing.provider.DatumShiftGridLoader;
import org.apache.sis.internal.referencing.provider.GeodeticOperation;
import org.apache.sis.internal.referencing.provider.Molodensky;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.datum.DefaultEllipsoid;
import org.apache.sis.referencing.operation.transform.InterpolatedGeocentricTransform;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

@XmlTransient
public class FranceGeocentricInterpolation
extends GeodeticOperation {
    private static final long serialVersionUID = -4707304160205218546L;
    public static final double TX = 168.0;
    public static final double TY = 60.0;
    public static final double TZ = -320.0;
    static final double PRECISION = 1.0E-4;
    private static final double[] ACCURACY = new double[]{0.05, 0.1, 0.2, 0.5, 1.0};
    private static final String HEADER = "GR3D";
    private static final String DEFAULT = "gr3df97a.txt";
    public static final ParameterDescriptor<Path> FILE;
    public static final ParameterDescriptorGroup PARAMETERS;

    public FranceGeocentricInterpolation() {
        this(2, 2, PARAMETERS, new FranceGeocentricInterpolation[4]);
        this.redimensioned[0] = this;
        this.redimensioned[1] = new FranceGeocentricInterpolation(2, 3, PARAMETERS, this.redimensioned);
        this.redimensioned[2] = new FranceGeocentricInterpolation(3, 2, PARAMETERS, this.redimensioned);
        this.redimensioned[3] = new FranceGeocentricInterpolation(3, 3, PARAMETERS, this.redimensioned);
    }

    FranceGeocentricInterpolation(int sourceDimensions, int targetDimensions, ParameterDescriptorGroup parameters, GeodeticOperation[] redimensioned) {
        super(sourceDimensions, targetDimensions, parameters, redimensioned);
    }

    public static boolean isRecognized(Path file) {
        return file.getFileName().toString().regionMatches(true, 0, DEFAULT, 0, 5);
    }

    @Override
    public final boolean isInvertible() {
        return false;
    }

    @Override
    public int getEllipsoidsMask() {
        return 3;
    }

    private static Ellipsoid createEllipsoid(Parameters values, ParameterDescriptor<Double> semiMajor, ParameterDescriptor<Double> semiMinor, Ellipsoid candidate) {
        double semiMajorAxis = values.doubleValue(semiMajor);
        double semiMinorAxis = values.doubleValue(semiMinor);
        if (candidate != null && Math.abs(candidate.getSemiMajorAxis() - semiMajorAxis) < 1.0E-6 && Math.abs(candidate.getSemiMinorAxis() - semiMinorAxis) < 1.0E-6) {
            return candidate;
        }
        return DefaultEllipsoid.createEllipsoid(Collections.singletonMap("name", NilReferencingObject.UNNAMED), semiMajorAxis, semiMinorAxis, Units.METRE);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) throws ParameterNotFoundException, FactoryException {
        double[] dArray;
        Path file;
        boolean withHeights = false;
        Parameters pg = Parameters.castOrWrap(values);
        Integer dim = (Integer)pg.getValue(Molodensky.DIMENSION);
        if (dim != null) {
            switch (dim) {
                case 2: {
                    break;
                }
                case 3: {
                    withHeights = true;
                    break;
                }
                default: {
                    throw new InvalidParameterValueException(Errors.format((short)45, "dim", dim), "dim", (Object)dim);
                }
            }
        }
        if (FranceGeocentricInterpolation.isRecognized(file = pg.getMandatoryValue(FILE))) {
            double[] dArray2 = new double[3];
            dArray2[0] = 168.0;
            dArray2[1] = 60.0;
            dArray = dArray2;
            dArray2[2] = -320.0;
        } else {
            dArray = null;
        }
        DatumShiftGridFile<Angle, Length> grid = FranceGeocentricInterpolation.getOrLoad(file, dArray, 1.0E-4);
        MathTransform tr = this.createGeodeticTransformation(factory, FranceGeocentricInterpolation.createEllipsoid(pg, (ParameterDescriptor<Double>)Molodensky.TGT_SEMI_MAJOR, (ParameterDescriptor<Double>)Molodensky.TGT_SEMI_MINOR, CommonCRS.ETRS89.ellipsoid()), FranceGeocentricInterpolation.createEllipsoid(pg, (ParameterDescriptor<Double>)Molodensky.SRC_SEMI_MAJOR, (ParameterDescriptor<Double>)Molodensky.SRC_SEMI_MINOR, null), withHeights, grid);
        try {
            tr = tr.inverse();
        }
        catch (NoninvertibleTransformException e) {
            throw new FactoryException((Throwable)e);
        }
        return tr;
    }

    MathTransform createGeodeticTransformation(MathTransformFactory factory, Ellipsoid source, Ellipsoid target, boolean withHeights, DatumShiftGridFile<Angle, Length> grid) throws FactoryException {
        return InterpolatedGeocentricTransform.createGeodeticTransformation(factory, source, withHeights, target, withHeights, grid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatumShiftGridFile<Angle, Length> getOrLoad(Path file, double[] averages, double scale) throws FactoryException {
        DatumShiftGridFile<Object, Object> grid;
        block12: {
            Path resolved = DataDirectory.DATUM_CHANGES.resolve(file).toAbsolutePath();
            grid = DatumShiftGridFile.CACHE.peek(resolved);
            if (grid == null) {
                Cache.Handler<DatumShiftGridFile<?, ?>> handler = DatumShiftGridFile.CACHE.lock(resolved);
                try {
                    grid = handler.peek();
                    if (grid != null) break block12;
                    try (BufferedReader in = Files.newBufferedReader(resolved);){
                        DatumShiftGridLoader.log(FranceGeocentricInterpolation.class, file);
                        DatumShiftGridFile.Float<Angle, Length> g = FranceGeocentricInterpolation.load(in, file);
                        grid = DatumShiftGridCompressed.compress(g, averages, scale);
                    }
                    catch (IOException | RuntimeException | NoninvertibleTransformException e) {
                        throw DatumShiftGridLoader.canNotLoad(HEADER, file, (Exception)e);
                    }
                    grid = grid.useSharedData();
                }
                finally {
                    handler.putAndUnlock(grid);
                }
            }
        }
        return grid.castTo(Angle.class, Length.class);
    }

    static DatumShiftGridFile.Float<Angle, Length> load(BufferedReader in, Path file) throws IOException, FactoryException, NoninvertibleTransformException {
        String line;
        DatumShiftGridFile.Float<Angle, Length> grid = null;
        double x0 = 0.0;
        double xf = 0.0;
        double y0 = 0.0;
        double yf = 0.0;
        double \u0394x = 0.0;
        double \u0394y = 0.0;
        int nx = 0;
        int ny = 0;
        while (true) {
            int p;
            if ((line = in.readLine()) == null) {
                throw new EOFException(Errors.format((short)137, file));
            }
            int length = CharSequences.skipTrailingWhitespaces(line, 0, line.length());
            if (length <= 0 || line.charAt(p = CharSequences.skipLeadingWhitespaces(line, 0, length)) == '#') continue;
            if (!line.regionMatches(true, p, HEADER, 0, HEADER.length())) break;
            if ((p += HEADER.length()) >= length) continue;
            char c = line.charAt(p);
            p = CharSequences.skipLeadingWhitespaces(line, p + 1, length);
            switch (c) {
                case '1': {
                    if (grid != null) {
                        throw new FactoryException(Errors.format((short)24, HEADER));
                    }
                    double[] gridGeometry = CharSequences.parseDoubles(line.substring(p, length), ' ');
                    if (gridGeometry.length != 6) break;
                    x0 = gridGeometry[0];
                    xf = gridGeometry[1];
                    y0 = gridGeometry[2];
                    yf = gridGeometry[3];
                    \u0394x = gridGeometry[4];
                    \u0394y = gridGeometry[5];
                    nx = Math.toIntExact(Math.round((xf - x0) / \u0394x + 1.0));
                    ny = Math.toIntExact(Math.round((yf - y0) / \u0394y + 1.0));
                    grid = new DatumShiftGridFile.Float<Angle, Length>(3, Units.DEGREE, Units.METRE, false, x0, y0, \u0394x, \u0394y, nx, ny, PARAMETERS, file);
                    break;
                }
                case '2': {
                    String interp = line.substring(p, length);
                    if (interp.matches("(?i)INTERPOLATION[^A-Z]+BILINEAIRE")) break;
                    LogRecord record = Errors.getResources((Locale)null).getLogRecord(Level.WARNING, (short)161, interp);
                    record.setLoggerName("org.apache.sis.referencing.operation");
                    Logging.log(FranceGeocentricInterpolation.class, "createMathTransform", record);
                    break;
                }
            }
        }
        if (grid == null) {
            throw new FactoryException(Errors.format((short)10, HEADER, file));
        }
        float[] tX = grid.offsets[0];
        float[] tY = grid.offsets[1];
        float[] tZ = grid.offsets[2];
        do {
            StringTokenizer t = new StringTokenizer(line.trim());
            t.nextToken();
            double x = Double.parseDouble(t.nextToken());
            double y = Double.parseDouble(t.nextToken());
            int i = Math.toIntExact(Math.round((x - x0) / \u0394x));
            int j = Math.toIntExact(Math.round((y - y0) / \u0394y));
            if (i < 0 || i >= nx) {
                throw new FactoryException(Errors.format((short)166, "x", x, x0, xf));
            }
            if (j < 0 || j >= ny) {
                throw new FactoryException(Errors.format((short)166, "y", y, y0, yf));
            }
            int p = j * nx + i;
            if (!(Double.isNaN(tX[p]) && Double.isNaN(tY[p]) && Double.isNaN(tZ[p]))) {
                throw new FactoryException(Errors.format((short)164, x + ", " + y));
            }
            tX[p] = -Float.parseFloat(t.nextToken());
            tY[p] = -Float.parseFloat(t.nextToken());
            tZ[p] = -Float.parseFloat(t.nextToken());
            double accuracy = ACCURACY[Math.min(ACCURACY.length - 1, Math.max(0, Integer.parseInt(t.nextToken()) - 1))];
            if (accuracy >= grid.accuracy) continue;
            grid.accuracy = accuracy;
        } while ((line = in.readLine()) != null);
        return grid;
    }

    static {
        ParameterBuilder builder = FranceGeocentricInterpolation.builder();
        FILE = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("8727")).addName("Geocentric translation file")).create(Path.class, Paths.get(DEFAULT, new String[0]));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)builder.addIdentifier("9655")).addName("France geocentric interpolation")).createGroup(new GeneralParameterDescriptor[]{Molodensky.DIMENSION, Molodensky.SRC_SEMI_MAJOR, Molodensky.SRC_SEMI_MINOR, Molodensky.TGT_SEMI_MAJOR, Molodensky.TGT_SEMI_MINOR, FILE});
    }
}

