/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import javax.measure.Unit;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class WraparoundAdjustment {
    private Envelope domainOfValidity;
    private final MathTransform domainToAOI;
    private final MathTransform domainToAny;
    private MathTransform geographicToAOI;
    private CoordinateReferenceSystem crs;
    private boolean isDomainTransformed;
    private boolean isResultTransformed;

    public WraparoundAdjustment(Envelope domainOfValidity, MathTransform domainToAOI, MathTransform domainToAny) {
        this.domainOfValidity = domainOfValidity;
        this.domainToAOI = domainToAOI;
        this.domainToAny = domainToAny;
    }

    static double range(CoordinateSystem cs, int dimension) {
        CoordinateSystemAxis axis = cs.getAxis(dimension);
        if (axis != null && RangeMeaning.WRAPAROUND.equals((Object)axis.getRangeMeaning())) {
            double period = axis.getMaximumValue() - axis.getMinimumValue();
            if (period > 0.0 && period != Double.POSITIVE_INFINITY) {
                return period;
            }
            AxisDirection dir = AxisDirections.absolute(axis.getDirection());
            if (AxisDirection.EAST.equals((Object)dir) && cs instanceof EllipsoidalCS) {
                period = 360.0;
                Unit unit = axis.getUnit();
                if (unit != null) {
                    period = Units.DEGREE.getConverterTo(Units.ensureAngular(unit)).convert(period);
                }
                return period;
            }
        }
        return Double.NaN;
    }

    private boolean setIfNonNull(CoordinateReferenceSystem crs) {
        if (crs == null) {
            assert (this.domainToAOI == null || this.domainToAOI.isIdentity());
            crs = this.domainOfValidity.getCoordinateReferenceSystem();
            if (crs == null) {
                return false;
            }
        }
        this.crs = crs;
        return true;
    }

    private boolean replaceCRS() {
        if (this.crs instanceof ProjectedCRS) {
            ProjectedCRS p = (ProjectedCRS)this.crs;
            this.crs = p.getBaseCRS();
            this.geographicToAOI = p.getConversionFromBase().getMathTransform();
            return true;
        }
        return false;
    }

    private void transformDomainToAOI() throws TransformException {
        if (!this.isDomainTransformed) {
            this.isDomainTransformed = true;
            MathTransform domainToGeographic = this.domainToAOI;
            if (domainToGeographic == null) {
                domainToGeographic = this.geographicToAOI;
            } else if (this.geographicToAOI != null) {
                domainToGeographic = MathTransforms.concatenate(domainToGeographic, this.geographicToAOI.inverse());
            }
            if (domainToGeographic != null && !domainToGeographic.isIdentity()) {
                this.domainOfValidity = Envelopes.transform(domainToGeographic, this.domainOfValidity);
            }
        }
    }

    private MathTransform toFinal() throws TransformException {
        MathTransform mt = this.domainToAny;
        if (this.isResultTransformed && this.geographicToAOI != null) {
            mt = MathTransforms.concatenate(this.geographicToAOI, mt);
        }
        return mt;
    }

    public GeneralEnvelope shift(Envelope areaOfInterest) throws TransformException {
        if (this.setIfNonNull(areaOfInterest.getCoordinateReferenceSystem())) {
            DirectPosition upperCorner;
            DirectPosition lowerCorner;
            GeneralEnvelope shifted;
            if (this.replaceCRS()) {
                shifted = Envelopes.transform(this.geographicToAOI.inverse(), areaOfInterest);
                lowerCorner = shifted.getLowerCorner();
                upperCorner = shifted.getUpperCorner();
            } else {
                shifted = null;
                lowerCorner = areaOfInterest.getLowerCorner();
                upperCorner = areaOfInterest.getUpperCorner();
            }
            CoordinateSystem cs = this.crs.getCoordinateSystem();
            int i = cs.getDimension();
            while (--i >= 0) {
                boolean upperIsAfter;
                double period = WraparoundAdjustment.range(cs, i);
                if (!(period > 0.0)) continue;
                this.transformDomainToAOI();
                double lower = lowerCorner.getOrdinate(i);
                double upper = upperCorner.getOrdinate(i);
                double lowerCycles = 0.0;
                double upperCycles = 0.0;
                double delta = upper - lower;
                if (MathFunctions.isNegative(delta)) {
                    double cycles = delta == 0.0 ? -1.0 : Math.floor(delta / period);
                    if (Math.abs(lower + (delta = cycles * period)) < Math.abs(upper - delta)) {
                        lowerCycles = cycles;
                    } else {
                        upperCycles = -cycles;
                    }
                }
                double validStart = this.domainOfValidity.getMinimum(i);
                double validEnd = this.domainOfValidity.getMaximum(i);
                double lowerToValidStart = (validStart - lower) / period - lowerCycles;
                double upperToValidEnd = (validEnd - upper) / period - upperCycles;
                boolean lowerIsBefore = lowerToValidStart > 0.0;
                boolean bl = upperIsAfter = upperToValidEnd < 0.0;
                if (lowerIsBefore != upperIsAfter) {
                    double cycles;
                    double upperToValidStart = (validStart - upper) / period - upperCycles;
                    double lowerToValidEnd = (validEnd - lower) / period - lowerCycles;
                    if (lowerIsBefore) {
                        cycles = Math.min(Math.floor(lowerToValidEnd), Math.max(Math.floor(lowerToValidStart), Math.ceil(upperToValidStart)));
                        upperCycles = cycles + 1.0 < lowerToValidEnd ? (upperCycles += Math.ceil(upperToValidEnd)) : (upperCycles += cycles);
                        lowerCycles += cycles;
                    } else {
                        cycles = Math.max(Math.ceil(upperToValidStart), Math.min(Math.ceil(upperToValidEnd), Math.floor(lowerToValidEnd)));
                        lowerCycles = cycles - 1.0 > upperToValidStart ? (lowerCycles += Math.floor(lowerToValidStart)) : (lowerCycles += cycles);
                        upperCycles += cycles;
                    }
                }
                if (lowerCycles == 0.0 && upperCycles == 0.0) continue;
                this.isResultTransformed = true;
                if (shifted == null) {
                    shifted = new GeneralEnvelope(areaOfInterest);
                }
                areaOfInterest = shifted;
                shifted.setRange(i, lower + lowerCycles * period, upper + upperCycles * period);
            }
        }
        return Envelopes.transform(this.toFinal(), areaOfInterest);
    }

    public DirectPosition shift(DirectPosition pointOfInterest) throws TransformException {
        if (this.setIfNonNull(pointOfInterest.getCoordinateReferenceSystem())) {
            DirectPosition shifted = this.replaceCRS() ? this.geographicToAOI.inverse().transform(pointOfInterest, null) : pointOfInterest;
            CoordinateSystem cs = this.crs.getCoordinateSystem();
            int i = cs.getDimension();
            while (--i >= 0) {
                double period = WraparoundAdjustment.range(cs, i);
                if (!(period > 0.0)) continue;
                this.transformDomainToAOI();
                double x = shifted.getOrdinate(i);
                double delta = this.domainOfValidity.getMinimum(i) - x;
                if (delta > 0.0) {
                    delta = Math.ceil(delta / period);
                } else {
                    delta = this.domainOfValidity.getMaximum(i) - x;
                    if (!(delta < 0.0)) continue;
                    delta = Math.floor(delta / period);
                }
                if (delta == 0.0) continue;
                this.isResultTransformed = true;
                if (shifted == pointOfInterest) {
                    shifted = new GeneralDirectPosition(pointOfInterest);
                }
                pointOfInterest = shifted;
                shifted.setOrdinate(i, x + delta * period);
            }
        }
        return this.toFinal().transform(pointOfInterest, null);
    }
}

