/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.time.Instant;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;

public final class TemporalAccessor {
    public final int dimension;
    public final DefaultTemporalCRS timeCRS;

    private TemporalAccessor(int dim, TemporalCRS crs) {
        this.dimension = dim;
        this.timeCRS = DefaultTemporalCRS.castOrCopy(crs);
    }

    public static TemporalAccessor of(CoordinateReferenceSystem crs, int dim) {
        if (crs instanceof TemporalCRS) {
            return new TemporalAccessor(dim, (TemporalCRS)crs);
        }
        if (crs instanceof CompoundCRS) {
            for (CoordinateReferenceSystem component : ((CompoundCRS)crs).getComponents()) {
                TemporalAccessor accessor = TemporalAccessor.of(component, dim);
                if (accessor != null) {
                    return accessor;
                }
                dim += ReferencingUtilities.getDimension(component);
            }
        }
        return null;
    }

    public Instant[] getTimeRange(AbstractEnvelope envelope) {
        Instant startTime = this.timeCRS.toInstant(envelope.getLower(this.dimension));
        Instant endTime = this.timeCRS.toInstant(envelope.getUpper(this.dimension));
        if (startTime == null) {
            startTime = endTime;
            endTime = null;
        }
        Instant[] times = new Instant[endTime != null ? 2 : (startTime != null ? 1 : 0)];
        switch (times.length) {
            default: {
                times[1] = endTime;
            }
            case 1: {
                times[0] = startTime;
            }
            case 0: 
        }
        return times;
    }
}

