/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultEllipsoidalCS;
import org.apache.sis.referencing.datum.DefaultPrimeMeridian;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Static;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;

public final class ReferencingUtilities
extends Static {
    private ReferencingUtilities() {
    }

    public static double getGreenwichLongitude(PrimeMeridian primeMeridian, Unit<Angle> unit) {
        if (primeMeridian == null) {
            return 0.0;
        }
        if (primeMeridian instanceof DefaultPrimeMeridian) {
            return ((DefaultPrimeMeridian)primeMeridian).getGreenwichLongitude(unit);
        }
        return primeMeridian.getAngularUnit().getConverterTo(unit).convert(primeMeridian.getGreenwichLongitude());
    }

    public static Unit<?> getUnit(CoordinateSystem cs) {
        Unit unit = null;
        if (cs != null) {
            int i = cs.getDimension();
            while (--i >= 0) {
                Unit candidate;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (axis == null || (candidate = axis.getUnit()) == null) continue;
                if (unit == null) {
                    unit = candidate;
                    continue;
                }
                if (unit.equals(candidate)) continue;
                return null;
            }
        }
        return unit;
    }

    public static int getDimension(CoordinateReferenceSystem crs) {
        CoordinateSystem cs;
        if (crs != null && (cs = crs.getCoordinateSystem()) != null) {
            return cs.getDimension();
        }
        return 0;
    }

    public static Class<?> getInterface(IdentifiedObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object).getInterface();
        }
        return object.getClass();
    }

    public static boolean getSingleComponents(Iterable<? extends CoordinateReferenceSystem> source, Collection<? super SingleCRS> addTo) throws ClassCastException {
        boolean sameContent = true;
        for (CoordinateReferenceSystem coordinateReferenceSystem : source) {
            if (coordinateReferenceSystem instanceof CompoundCRS) {
                ReferencingUtilities.getSingleComponents(((CompoundCRS)coordinateReferenceSystem).getComponents(), addTo);
                sameContent = false;
                continue;
            }
            addTo.add((SingleCRS)((SingleCRS)coordinateReferenceSystem));
        }
        return sameContent;
    }

    public static boolean isEllipsoidalHeight(VerticalDatum datum) {
        VerticalDatumType type;
        if (datum != null && (type = datum.getVerticalDatumType()) != null) {
            return "ELLIPSOIDAL".equalsIgnoreCase(type.name());
        }
        return false;
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem crs) {
        if (crs != null) {
            Ellipsoid e;
            Datum datum;
            if (crs instanceof SingleCRS && (datum = ((SingleCRS)crs).getDatum()) instanceof GeodeticDatum && (e = ((GeodeticDatum)datum).getEllipsoid()) != null) {
                return e;
            }
            if (crs instanceof CompoundCRS) {
                for (CoordinateReferenceSystem c : ((CompoundCRS)crs).getComponents()) {
                    Ellipsoid e2 = ReferencingUtilities.getEllipsoid(c);
                    if (e2 == null) continue;
                    return e2;
                }
            }
        }
        return null;
    }

    public static Ellipsoid getEllipsoidOfGeographicCRS(CoordinateReferenceSystem crs) {
        while (!(crs instanceof GeodeticCRS)) {
            if (crs instanceof CompoundCRS) {
                crs = (CoordinateReferenceSystem)((CompoundCRS)crs).getComponents().get(0);
                continue;
            }
            return null;
        }
        if (crs.getCoordinateSystem() instanceof EllipsoidalCS) {
            return ((GeodeticCRS)crs).getDatum().getEllipsoid();
        }
        return null;
    }

    public static GeographicCRS toNormalizedGeographicCRS(CoordinateReferenceSystem crs, boolean latlon, boolean allow3D) {
        while (crs instanceof GeneralDerivedCRS) {
            crs = ((GeneralDerivedCRS)crs).getBaseCRS();
        }
        if (crs instanceof GeodeticCRS) {
            EllipsoidalCS normalizedCS;
            CoordinateSystem cs = crs.getCoordinateSystem();
            if (!latlon && crs instanceof DefaultGeographicCRS && (allow3D || cs.getDimension() == 2)) {
                return ((DefaultGeographicCRS)crs).forConvention(AxesConvention.NORMALIZED);
            }
            if (allow3D && cs.getDimension() >= 3) {
                normalizedCS = CommonCRS.WGS84.geographic3D().getCoordinateSystem();
                if (!latlon) {
                    normalizedCS = DefaultEllipsoidalCS.castOrCopy(normalizedCS).forConvention(AxesConvention.NORMALIZED);
                }
            } else {
                normalizedCS = latlon ? CommonCRS.WGS84.geographic().getCoordinateSystem() : CommonCRS.defaultGeographic().getCoordinateSystem();
            }
            if (crs instanceof GeographicCRS && Utilities.equalsIgnoreMetadata(normalizedCS, cs)) {
                return (GeographicCRS)crs;
            }
            return new DefaultGeographicCRS(Collections.singletonMap("name", NilReferencingObject.UNNAMED), ((GeodeticCRS)crs).getDatum(), normalizedCS);
        }
        if (crs instanceof CompoundCRS) {
            for (CoordinateReferenceSystem e : ((CompoundCRS)crs).getComponents()) {
                GeographicCRS candidate = ReferencingUtilities.toNormalizedGeographicCRS(e, latlon, allow3D);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static Map<String, ?> getPropertiesForModifiedCRS(IdentifiedObject object) {
        String name;
        Map<String, ?> properties = IdentifiedObjects.getProperties(object, "identifiers");
        Identifier id = (Identifier)properties.get("name");
        if (id != null && (name = id.getCode()) != null) {
            int c;
            for (int i = 0; i < name.length(); i += Character.charCount(c)) {
                String extra;
                int endAt;
                c = name.codePointAt(i);
                if (Character.isUnicodeIdentifierPart(c) || Character.isSpaceChar(c)) continue;
                if (c == 40 && (endAt = name.indexOf(41, i)) >= 0 && CharSequences.isUnicodeIdentifier(extra = name.substring(i + 1, endAt))) {
                    i += extra.length() + 2;
                }
                if ((name = CharSequences.trimWhitespaces(name, 0, i).toString()).isEmpty()) continue;
                HashMap copy = new HashMap(properties);
                copy.put("name", name);
                return copy;
            }
        }
        return properties;
    }

    public static StringBuilder toPropertyName(Class<?> base, Class<?> type) {
        String name;
        int length;
        StringBuilder buffer;
        Specification spec;
        UML uml = type.getAnnotation(UML.class);
        if (uml != null && (spec = uml.specification()) == Specification.ISO_19111 && (buffer = new StringBuilder(length = (name = uml.identifier()).length()).append(name, name.indexOf(95) + 1, length)).length() != 0) {
            buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
            return buffer;
        }
        for (Class<?> c : type.getInterfaces()) {
            StringBuilder name2;
            if (!base.isAssignableFrom(c) || (name2 = ReferencingUtilities.toPropertyName(base, c)) == null) continue;
            return name2;
        }
        return null;
    }

    public static DefaultMathTransformFactory.Context createTransformContext(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, DefaultMathTransformFactory.Context context) {
        CoordinateSystem targetCS;
        if (context == null) {
            context = new DefaultMathTransformFactory.Context();
        }
        CoordinateSystem sourceCS = sourceCRS != null ? sourceCRS.getCoordinateSystem() : null;
        CoordinateSystem coordinateSystem = targetCS = targetCRS != null ? targetCRS.getCoordinateSystem() : null;
        if (sourceCRS instanceof GeodeticCRS && sourceCS instanceof EllipsoidalCS) {
            context.setSource((EllipsoidalCS)sourceCS, ((GeodeticCRS)sourceCRS).getDatum().getEllipsoid());
        } else {
            context.setSource(sourceCS);
        }
        if (targetCRS instanceof GeodeticCRS && targetCS instanceof EllipsoidalCS) {
            context.setTarget((EllipsoidalCS)targetCS, ((GeodeticCRS)targetCRS).getDatum().getEllipsoid());
        } else {
            context.setTarget(targetCS);
        }
        return context;
    }

    public static Map<Integer, String> identifierToName(ParameterDescriptorGroup parameters, Citation authority) {
        HashMap<Integer, String> mapping = new HashMap<Integer, String>();
        for (GeneralParameterDescriptor descriptor : parameters.descriptors()) {
            Identifier id = IdentifiedObjects.getIdentifier((IdentifiedObject)descriptor, authority);
            if (id == null) continue;
            String name = IdentifiedObjects.getName((IdentifiedObject)descriptor, authority);
            if (name == null) {
                name = IdentifiedObjects.getName((IdentifiedObject)descriptor, null);
            }
            if (mapping.put(Integer.valueOf(id.getCode()), name) == null) continue;
            throw new IllegalArgumentException(Errors.format((short)25, id));
        }
        return mapping;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] getShortAxisNames(Vocabulary resources, CoordinateReferenceSystem crs) {
        boolean isGeographic = crs instanceof GeographicCRS;
        boolean isProjected = crs instanceof ProjectedCRS;
        CoordinateSystem cs = crs.getCoordinateSystem();
        String[] names = new String[cs.getDimension()];
        int i = 0;
        while (i < names.length) {
            int key = 0;
            CoordinateSystemAxis axis = cs.getAxis(i);
            AxisDirection direction = axis.getDirection();
            if (AxisDirections.isCardinal(direction)) {
                boolean isMeridional;
                boolean bl = isMeridional = AxisDirection.NORTH.equals((Object)direction) || AxisDirection.SOUTH.equals((Object)direction);
                if (isGeographic) {
                    key = isMeridional ? 57 : 65;
                } else if (!isProjected) {
                    // empty if block
                }
            } else if (AxisDirection.UP.equals((Object)direction) && isGeographic | isProjected) {
                key = 46;
            }
            names[i] = key != 0 ? resources.getString((short)key) : axis.getName().getCode();
            ++i;
        }
        return names;
    }
}

