/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Map;
import org.apache.sis.internal.referencing.CoordinateOperations;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.factory.NoSuchAuthorityFactoryException;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.Factory;
import org.opengis.util.FactoryException;

public class ReferencingFactoryContainer {
    public static final String MT_FACTORY = "mtFactory";
    public static final String CRS_FACTORY = "crsFactory";
    public static final String CS_FACTORY = "csFactory";
    public static final String DATUM_FACTORY = "datumFactory";
    private CRSAuthorityFactory crsAuthorityFactory;
    private DatumFactory datumFactory;
    private CSFactory csFactory;
    private CRSFactory crsFactory;
    private DefaultCoordinateOperationFactory operationFactory;
    private MathTransformFactory mtFactory;
    private Map<String, ?> defaultProperties;

    public ReferencingFactoryContainer() {
    }

    public ReferencingFactoryContainer(Map<String, ?> defaultProperties, CRSFactory crsFactory, CSFactory csFactory, DatumFactory datumFactory, CoordinateOperationFactory operationFactory, MathTransformFactory mtFactory) {
        this.defaultProperties = defaultProperties;
        this.crsFactory = crsFactory;
        this.csFactory = csFactory;
        this.datumFactory = datumFactory;
        this.operationFactory = (DefaultCoordinateOperationFactory)operationFactory;
        this.mtFactory = mtFactory;
    }

    public final <T extends Factory> boolean setFactory(Class<T> type, T factory) {
        if (type == CRSFactory.class) {
            this.crsFactory = (CRSFactory)factory;
            return this.crsFactory != this.crsFactory;
        }
        if (type == CSFactory.class) {
            this.csFactory = (CSFactory)factory;
            return this.csFactory != this.csFactory;
        }
        if (type == DatumFactory.class) {
            this.datumFactory = (DatumFactory)factory;
            return this.datumFactory != this.datumFactory;
        }
        if (type == CoordinateOperationFactory.class) {
            this.operationFactory = (DefaultCoordinateOperationFactory)factory;
            return this.operationFactory != this.operationFactory;
        }
        if (type == MathTransformFactory.class) {
            this.mtFactory = (MathTransformFactory)factory;
            return this.mtFactory != this.mtFactory;
        }
        throw new IllegalArgumentException(Errors.format((short)45, "type", type));
    }

    public final <T extends Factory> T getFactory(Class<T> type) {
        Object f;
        if (type == CRSFactory.class) {
            f = this.getCRSFactory();
        } else if (type == CSFactory.class) {
            f = this.getCSFactory();
        } else if (type == DatumFactory.class) {
            f = this.getDatumFactory();
        } else if (type == CoordinateOperationFactory.class) {
            f = this.getCoordinateOperationFactory();
        } else if (type == MathTransformFactory.class) {
            f = this.getMathTransformFactory();
        } else {
            throw new IllegalArgumentException(Errors.format((short)45, "type", type));
        }
        return (T)((Factory)type.cast(f));
    }

    public final CRSAuthorityFactory getCRSAuthorityFactory() throws FactoryException {
        if (this.crsAuthorityFactory == null) {
            this.crsAuthorityFactory = CRS.getAuthorityFactory("EPSG");
        }
        return this.crsAuthorityFactory;
    }

    public final CSAuthorityFactory getCSAuthorityFactory() throws FactoryException {
        CRSAuthorityFactory factory = this.getCRSAuthorityFactory();
        if (factory instanceof CSAuthorityFactory) {
            return (CSAuthorityFactory)factory;
        }
        throw new NoSuchAuthorityFactoryException(null, "EPSG");
    }

    public final DatumAuthorityFactory getDatumAuthorityFactory() throws FactoryException {
        CRSAuthorityFactory factory = this.getCRSAuthorityFactory();
        if (factory instanceof DatumAuthorityFactory) {
            return (DatumAuthorityFactory)factory;
        }
        throw new NoSuchAuthorityFactoryException(null, "EPSG");
    }

    public final CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory() throws FactoryException {
        CRSAuthorityFactory factory = this.getCRSAuthorityFactory();
        if (factory instanceof CoordinateOperationAuthorityFactory) {
            return (CoordinateOperationAuthorityFactory)factory;
        }
        throw new NoSuchAuthorityFactoryException(null, "EPSG");
    }

    public final CRSFactory getCRSFactory() {
        if (this.crsFactory == null) {
            this.crsFactory = DefaultFactories.forBuildin(CRSFactory.class);
        }
        return this.crsFactory;
    }

    public final CSFactory getCSFactory() {
        if (this.csFactory == null) {
            this.csFactory = DefaultFactories.forBuildin(CSFactory.class);
        }
        return this.csFactory;
    }

    public final DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            this.datumFactory = DefaultFactories.forBuildin(DatumFactory.class);
        }
        return this.datumFactory;
    }

    public final DefaultCoordinateOperationFactory getCoordinateOperationFactory() {
        if (this.operationFactory == null) {
            CoordinateOperationFactory op = CoordinateOperations.getCoordinateOperationFactory(this.defaultProperties, this.mtFactory, this.crsFactory, this.csFactory);
            this.defaultProperties = null;
            this.operationFactory = op instanceof DefaultCoordinateOperationFactory ? (DefaultCoordinateOperationFactory)op : CoordinateOperations.factory();
        }
        return this.operationFactory;
    }

    public final MathTransformFactory getMathTransformFactory() {
        if (this.mtFactory == null) {
            this.mtFactory = DefaultFactories.forBuildin(MathTransformFactory.class);
        }
        return this.mtFactory;
    }

    public final CartesianCS getStandardProjectedCS() throws FactoryException {
        return this.getCSAuthorityFactory().createCartesianCS("4400");
    }
}

