/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collections;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public final class Legacy {
    private static final CartesianCS LEGACY = new DefaultCartesianCS((Map<String, ?>)Collections.singletonMap("name", "Legacy geocentric"), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Collections.singletonMap("name", "X"), "X", AxisDirection.OTHER, Units.METRE), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Collections.singletonMap("name", "Y"), "Y", AxisDirection.EAST, Units.METRE), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Collections.singletonMap("name", "Z"), "Z", AxisDirection.NORTH, Units.METRE));

    private Legacy() {
    }

    public static CartesianCS standard(Unit<?> unit) {
        return Legacy.replaceUnit((CartesianCS)CommonCRS.WGS84.geocentric().getCoordinateSystem(), unit);
    }

    public static CartesianCS forGeocentricCRS(CartesianCS cs, boolean toLegacy) {
        CartesianCS check = toLegacy ? Legacy.standard(null) : LEGACY;
        int dimension = check.getDimension();
        if (cs.getDimension() != dimension) {
            return cs;
        }
        for (int i = 0; i < dimension; ++i) {
            if (cs.getAxis(i).getDirection().equals((Object)check.getAxis(i).getDirection())) continue;
            return cs;
        }
        Unit<?> unit = ReferencingUtilities.getUnit((CoordinateSystem)cs);
        return toLegacy ? Legacy.replaceUnit(LEGACY, unit) : Legacy.standard(unit);
    }

    public static CartesianCS replaceUnit(CartesianCS cs, Unit<?> unit) {
        if (unit != null && !unit.equals(Units.METRE)) {
            cs = (CartesianCS)CoordinateSystems.replaceLinearUnit((CoordinateSystem)cs, (Unit<Length>)unit.asType(Length.class));
        }
        return cs;
    }
}

