/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Set;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.GeodeticException;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public final class EPSGFactoryProxy
implements CRSAuthorityFactory {
    private volatile CRSAuthorityFactory factory;

    private CRSAuthorityFactory factory() throws FactoryException {
        CRSAuthorityFactory f = this.factory;
        if (f == null) {
            this.factory = f = CRS.getAuthorityFactory("EPSG");
        }
        return f;
    }

    public Citation getAuthority() {
        try {
            return this.factory().getAuthority();
        }
        catch (FactoryException e) {
            throw new GeodeticException(e);
        }
    }

    public Citation getVendor() {
        try {
            return this.factory().getVendor();
        }
        catch (FactoryException e) {
            throw new GeodeticException(e);
        }
    }

    public InternationalString getDescriptionText(String code) throws FactoryException {
        return this.factory().getDescriptionText(code);
    }

    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.factory().createObject(code);
    }

    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        return this.factory().createCoordinateReferenceSystem(code);
    }

    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        return this.factory().createCompoundCRS(code);
    }

    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        return this.factory().createDerivedCRS(code);
    }

    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        return this.factory().createEngineeringCRS(code);
    }

    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        return this.factory().createGeographicCRS(code);
    }

    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        return this.factory().createGeocentricCRS(code);
    }

    public ImageCRS createImageCRS(String code) throws FactoryException {
        return this.factory().createImageCRS(code);
    }

    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        return this.factory().createProjectedCRS(code);
    }

    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        return this.factory().createTemporalCRS(code);
    }

    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        return this.factory().createVerticalCRS(code);
    }

    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        return this.factory().getAuthorityCodes(type);
    }
}

