/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.ucar;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.sis.internal.netcdf.Dimension;

final class DimensionWrapper
extends Dimension {
    private final ucar.nc2.Dimension netcdf;

    static List<Dimension> wrap(List<ucar.nc2.Dimension> dimensions) {
        return dimensions.stream().map(DimensionWrapper::new).collect(Collectors.toList());
    }

    static ucar.nc2.Dimension[] unwrap(Dimension[] dimensions) {
        ucar.nc2.Dimension[] ncd = new ucar.nc2.Dimension[dimensions.length];
        for (int i = 0; i < ncd.length; ++i) {
            ncd[i] = ((DimensionWrapper)dimensions[i]).netcdf;
        }
        return ncd;
    }

    private DimensionWrapper(ucar.nc2.Dimension netcdf) {
        this.netcdf = netcdf;
    }

    @Override
    public String getName() {
        return this.netcdf.getShortName();
    }

    @Override
    public long length() {
        return this.netcdf.getLength();
    }

    @Override
    protected boolean isUnlimited() {
        return this.netcdf.isUnlimited();
    }

    public boolean equals(Object other) {
        return other instanceof DimensionWrapper && this.netcdf.equals((Object)((DimensionWrapper)other).netcdf);
    }

    public int hashCode() {
        return ~this.netcdf.hashCode();
    }
}

