/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sis.internal.netcdf.impl.ChannelDecoder;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreContentException;

final class HYCOM {
    private static final Pattern DATE_PATTERN = Pattern.compile("days?\\s+as\\s+(?-i)%Y%m%d.*", 2);

    private HYCOM() {
    }

    static void convert(ChannelDecoder decoder, VariableInfo[] variables) throws IOException, DataStoreContentException {
        Matcher matcher = null;
        for (VariableInfo variable : variables) {
            String units;
            if (variable.dimensions.length != 1 || (units = variable.getUnitsString()) == null) continue;
            if (matcher == null) {
                matcher = DATE_PATTERN.matcher(units);
            } else {
                matcher.reset(units);
            }
            if (!matcher.matches()) continue;
            Instant epoch = variable.setUnit(decoder.findVariable(variable.dimensions[0].name), Units.DAY);
            if (epoch == null) {
                epoch = Instant.EPOCH;
            }
            long origin = epoch.toEpochMilli();
            Vector values = variable.read();
            double[] times = new double[values.size()];
            GregorianCalendar calendar = new GregorianCalendar(decoder.getTimeZone(), Locale.US);
            calendar.clear();
            for (int i = 0; i < times.length; ++i) {
                double time = values.doubleValue(i);
                long date = (long)time;
                time -= (double)date;
                int day = (int)(date % 100L);
                int month = (int)((date /= 100L) % 100L);
                calendar.set(Math.toIntExact(date /= 100L), month - 1, day, 0, 0, 0);
                date = calendar.getTimeInMillis() - origin;
                times[i] = time += (double)date / 8.64E7;
            }
            variable.setValues(times);
        }
    }
}

