/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.measure.Unit;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.netcdf.impl.DimensionInfo;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.cs.AxisDirection;

final class GridInfo
extends Grid {
    private static final Map<String, Character> AXIS_TYPES = new HashMap<String, Character>(26);
    private final DimensionInfo[] domain;
    private final VariableInfo[] range;

    private static void addAxisTypes(char abbreviation, String ... names) {
        Character c = Character.valueOf(abbreviation);
        for (String name : names) {
            AXIS_TYPES.put(name, c);
        }
    }

    GridInfo(DimensionInfo[] domain, VariableInfo[] range) {
        this.domain = domain;
        this.range = range;
    }

    @Override
    protected Grid forDimensions(Dimension[] dimensions) {
        int i = 0;
        for (DimensionInfo required : this.domain) {
            do {
                if (i < dimensions.length) continue;
                return null;
            } while (!required.equals(dimensions[i++]));
        }
        return this;
    }

    private String getFilename() {
        for (VariableInfo info : this.range) {
            String filename = info.getFilename();
            if (filename == null) continue;
            return filename;
        }
        return null;
    }

    @Override
    public String getName() {
        return GridInfo.listNames(this.range, this.range.length, " ");
    }

    private static char getAxisType(String name) {
        Character abbreviation;
        if (name != null && (abbreviation = AXIS_TYPES.get(name.toLowerCase(Locale.US))) != null) {
            return abbreviation.charValue();
        }
        return '\u0000';
    }

    @Override
    public int getSourceDimensions() {
        return this.domain.length;
    }

    @Override
    public int getTargetDimensions() {
        return this.range.length;
    }

    @Override
    protected List<Dimension> getDimensions() {
        return UnmodifiableArrayList.wrap(this.domain);
    }

    @Override
    protected boolean containsAllNamedAxes(String[] axisNames) {
        if (axisNames != null) {
            block0: for (String name : axisNames) {
                for (VariableInfo axis : this.range) {
                    if (name.equalsIgnoreCase(axis.getName())) continue block0;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected Axis[] createAxes(Decoder decoder) throws IOException, DataStoreException {
        TreeMap<VariableInfo, Integer> variables = new TreeMap<VariableInfo, Integer>();
        for (int i = 0; i < this.range.length; ++i) {
            VariableInfo v = this.range[i];
            if (variables.put(v, i) == null) continue;
            throw new DataStoreContentException(Resources.format((short)7, this.getFilename(), v.getName()));
        }
        Axis[] axes = new Axis[this.range.length];
        for (Map.Entry entry : variables.entrySet()) {
            int targetDim = (Integer)entry.getValue();
            VariableInfo axis = (VariableInfo)entry.getKey();
            char abbreviation = GridInfo.getAxisType(axis.getAxisType());
            if (abbreviation == '\u0000' && (abbreviation = GridInfo.getAxisType(axis.getAttributeAsString("standard_name"))) == '\u0000' && (abbreviation = GridInfo.getAxisType(axis.getDescription())) == '\u0000') {
                if (Units.isAngular(axis.getUnit())) {
                    AxisDirection direction = AxisDirections.absolute(Axis.direction(axis.getUnitsString()));
                    if (AxisDirection.EAST.equals((Object)direction)) {
                        abbreviation = '\u03bb';
                    } else if (AxisDirection.NORTH.equals((Object)direction)) {
                        abbreviation = '\u03c6';
                    }
                }
                if (abbreviation == '\u0000' && (abbreviation = GridInfo.getAxisType(axis.getName())) == '\u0000') {
                    Unit<?> unit = axis.getUnit();
                    if (Units.isTemporal(unit)) {
                        abbreviation = 't';
                    } else if (Units.isPressure(unit)) {
                        abbreviation = 'z';
                    }
                }
            }
            int i = 0;
            DimensionInfo[] axisDomain = axis.dimensions;
            int[] indices = new int[axisDomain.length];
            int[] sizes = new int[axisDomain.length];
            block2: for (DimensionInfo dimension : axisDomain) {
                for (int sourceDim = 0; sourceDim < this.domain.length; ++sourceDim) {
                    if (this.domain[sourceDim] != dimension) continue;
                    indices[i] = sourceDim;
                    sizes[i++] = dimension.length;
                    continue block2;
                }
            }
            axes[targetDim] = new Axis(abbreviation, axis.getAttributeAsString("positive"), ArraysExt.resize(indices, i), ArraysExt.resize(sizes, i), axis);
        }
        return axes;
    }

    public int hashCode() {
        return Arrays.hashCode(this.domain) ^ Arrays.hashCode(this.range);
    }

    public boolean equals(Object other) {
        if (other instanceof GridInfo) {
            GridInfo that = (GridInfo)other;
            return Arrays.equals(this.domain, that.domain) && Arrays.equals(this.range, that.range);
        }
        return false;
    }

    static {
        GridInfo.addAxisTypes('\u03bb', "longitude", "lon", "long");
        GridInfo.addAxisTypes('\u03c6', "latitude", "lat");
        GridInfo.addAxisTypes('H', "pressure", "height", "altitude", "barometric_altitude", "elevation", "elev", "geoz");
        GridInfo.addAxisTypes('D', "depth", "depth_below_geoid");
        GridInfo.addAxisTypes('E', "geox", "projection_x_coordinate");
        GridInfo.addAxisTypes('N', "geoy", "projection_y_coordinate");
        GridInfo.addAxisTypes('t', "t", "time", "runtime");
        GridInfo.addAxisTypes('x', "x");
        GridInfo.addAxisTypes('y', "y");
        GridInfo.addAxisTypes('z', "z");
    }
}

