/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.OptionalLong;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.internal.feature.MovingFeature;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.DiscreteSampling;
import org.apache.sis.internal.netcdf.impl.ChannelDecoder;
import org.apache.sis.internal.netcdf.impl.DimensionInfo;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.collection.BackingStoreException;

final class FeaturesInfo
extends DiscreteSampling {
    private final Vector counts;
    private final VariableInfo identifiers;
    private final VariableInfo time;
    private final VariableInfo[] coordinates;
    private final VariableInfo[] properties;
    private final DefaultFeatureType type;

    private FeaturesInfo(ChannelDecoder decoder, Vector counts, VariableInfo identifiers, VariableInfo time, Collection<VariableInfo> coordinates, Collection<VariableInfo> properties) {
        super(decoder.geomlib, decoder.listeners);
        this.counts = counts;
        this.identifiers = identifiers;
        this.coordinates = coordinates.toArray(new VariableInfo[coordinates.size()]);
        this.properties = properties.toArray(new VariableInfo[properties.size()]);
        this.time = time;
        HashMap<String, String> info = new HashMap<String, String>(4);
        AbstractIdentifiedType[] pt = new AbstractIdentifiedType[this.properties.length + 2];
        DefaultAttributeType[] characteristics = null;
        for (int i = 0; i < pt.length; ++i) {
            Class valueClass;
            VariableInfo variable;
            int minOccurs = 1;
            int maxOccurs = 1;
            switch (i) {
                case 0: {
                    variable = identifiers;
                    valueClass = Integer.class;
                    break;
                }
                case 1: {
                    variable = null;
                    valueClass = this.factory.polylineClass;
                    characteristics = new DefaultAttributeType[]{MovingFeature.TIME};
                    break;
                }
                default: {
                    variable = this.properties[i - 2];
                    valueClass = variable.meaning(0) != null ? String.class : Number.class;
                    minOccurs = 0;
                    maxOccurs = Integer.MAX_VALUE;
                }
            }
            info.put("name", variable != null ? variable.getName() : "trajectory");
            pt[i] = new DefaultAttributeType<Object>(info, valueClass, minOccurs, maxOccurs, null, characteristics);
        }
        String name = "Features";
        info.put("name", (String)decoder.nameFactory.createLocalName(decoder.namespace, name));
        this.type = new DefaultFeatureType(info, false, null, pt);
    }

    private static boolean isSupportedRole(String role) {
        return "trajectory_id".equalsIgnoreCase(role);
    }

    static FeaturesInfo[] create(ChannelDecoder decoder) throws IOException, DataStoreException {
        ArrayList<FeaturesInfo> features = new ArrayList<FeaturesInfo>(3);
        block4: for (VariableInfo counts : decoder.variables) {
            String sampleDimName;
            if (counts.dimensions.length != 1 || !counts.getDataType().isInteger || (sampleDimName = counts.getAttributeAsString("sample_dimension")) == null) continue;
            DimensionInfo featureDimension = counts.dimensions[0];
            DimensionInfo sampleDimension = decoder.findDimension(sampleDimName);
            if (sampleDimension == null) {
                decoder.listeners.warning(decoder.resources().getString((short)1, decoder.getFilename(), counts.getName(), sampleDimName));
                continue;
            }
            VariableInfo identifiers = decoder.findVariable(featureDimension.name);
            if (identifiers == null || !FeaturesInfo.isSupportedRole(identifiers.getAttributeAsString("cf_role"))) {
                VariableInfo replacement = null;
                for (VariableInfo alt : decoder.variables) {
                    if (alt.dimensions.length == 0 || alt.dimensions[0] != featureDimension || !FeaturesInfo.isSupportedRole(alt.getAttributeAsString("cf_role"))) continue;
                    if (replacement != null) {
                        replacement = null;
                        break;
                    }
                    replacement = alt;
                }
                if (replacement != null) {
                    identifiers = replacement;
                }
                if (identifiers == null) {
                    decoder.listeners.warning(decoder.resources().getString((short)3, decoder.getFilename(), featureDimension.name));
                    continue;
                }
            }
            for (int i = 0; i < identifiers.dimensions.length; ++i) {
                boolean isValid;
                switch (i) {
                    case 0: {
                        isValid = identifiers.dimensions[0] == featureDimension;
                        break;
                    }
                    case 1: {
                        isValid = identifiers.getDataType() == DataType.CHAR;
                        break;
                    }
                    default: {
                        isValid = false;
                    }
                }
                if (isValid) continue;
                decoder.listeners.warning(decoder.resources().getString((short)2, decoder.getFilename(), identifiers.getName(), featureDimension.getName(), identifiers.dimensions[i].name));
                continue block4;
            }
            LinkedHashMap<String, VariableInfo> coordinates = new LinkedHashMap<String, VariableInfo>();
            ArrayList<VariableInfo> properties = new ArrayList<VariableInfo>();
            for (VariableInfo data : decoder.variables) {
                if (data.dimensions.length != 1 || data.dimensions[0] != sampleDimension) continue;
                String axisType = data.getAttributeAsString("axis");
                if (axisType == null) {
                    properties.add(data);
                    continue;
                }
                if (coordinates.put(axisType, data) != null) continue block4;
            }
            VariableInfo time = (VariableInfo)coordinates.remove("T");
            if (time == null) continue;
            features.add(new FeaturesInfo(decoder, counts.read(), identifiers, time, coordinates.values(), properties));
        }
        return features.toArray(new FeaturesInfo[features.size()]);
    }

    @Override
    public DefaultFeatureType getType() {
        return this.type;
    }

    @Override
    protected OptionalLong getFeatureCount() {
        return OptionalLong.of(this.counts.size());
    }

    @Override
    public Stream<AbstractFeature> features(boolean parallel) {
        return StreamSupport.stream(new Iter(), false);
    }

    private final class Iter
    implements Spliterator<AbstractFeature> {
        private int index;
        private int position;

        Iter() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super AbstractFeature> action) {
            Vector id;
            int length = FeaturesInfo.this.counts.intValue(this.index);
            GridExtent extent = new GridExtent(null, new long[]{this.position}, new long[]{Math.addExact(this.position, length)}, false);
            int[] step = new int[]{1};
            Vector[] coords = new Vector[FeaturesInfo.this.coordinates.length];
            Object[] props = new Object[FeaturesInfo.this.properties.length];
            try {
                int i;
                id = FeaturesInfo.this.identifiers.read();
                Vector t = FeaturesInfo.this.time.read(extent, step);
                for (i = 0; i < FeaturesInfo.this.coordinates.length; ++i) {
                    coords[i] = FeaturesInfo.this.coordinates[i].read(extent, step);
                }
                for (i = 0; i < FeaturesInfo.this.properties.length; ++i) {
                    VariableInfo p = FeaturesInfo.this.properties[i];
                    Vector data = p.read(extent, step);
                    if (p.isEnumeration()) {
                        String[] meanings = new String[data.size()];
                        for (int j = 0; j < meanings.length; ++j) {
                            String m = p.meaning(data.intValue(j));
                            meanings[j] = m != null ? m : "";
                        }
                        props[i] = Arrays.asList(meanings);
                        continue;
                    }
                    props[i] = data;
                }
            }
            catch (IOException | DataStoreException e) {
                throw new BackingStoreException(FeaturesInfo.this.canNotReadFile(), e);
            }
            AbstractFeature feature = FeaturesInfo.this.type.newInstance();
            feature.setPropertyValue(FeaturesInfo.this.identifiers.getName(), id.intValue(this.index));
            for (int i = 0; i < FeaturesInfo.this.properties.length; ++i) {
                feature.setPropertyValue(FeaturesInfo.this.properties[i].getName(), props[i]);
            }
            int dimension = FeaturesInfo.this.coordinates.length;
            double[] tmp = new double[length * dimension];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = coords[i % dimension].doubleValue(i / dimension);
            }
            feature.setPropertyValue("trajectory", FeaturesInfo.this.factory.createPolyline(dimension, Vector.create(tmp)));
            action.accept(feature);
            this.position = Math.addExact(this.position, length);
            return ++this.index < FeaturesInfo.this.counts.size();
        }

        @Override
        public Spliterator<AbstractFeature> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return FeaturesInfo.this.counts.size();
        }

        @Override
        public int characteristics() {
            return 1360;
        }
    }
}

