/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.measure.Unit;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.netcdf.Convention;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Grid;
import org.apache.sis.internal.netcdf.GridMapping;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.WeakHashSet;
import org.opengis.referencing.operation.Matrix;

public abstract class Variable
extends Node {
    protected static final WeakHashSet<Vector> SHARED_VECTORS = new WeakHashSet<Vector>(Vector.class);
    public static final Pattern TIME_UNIT_PATTERN = Pattern.compile("(.+)\\Wsince\\W(.+)", 2);
    private Unit<?> unit;
    protected Instant epoch;
    private boolean unitParsed;
    private Map<Number, Object> nodataValues;
    private GridGeometry gridGeometry;
    private boolean gridDetermined;
    int bandDimension;

    protected Variable(Decoder decoder) {
        super(decoder);
    }

    public String getFilename() {
        return this.decoder.getFilename();
    }

    @Override
    public abstract String getName();

    public final String getStandardName() {
        String name = this.getAttributeAsString("standard_name");
        if (name == null && (name = this.getAttributeAsString("long_name")) == null) {
            name = this.getName();
        }
        return name;
    }

    public abstract String getDescription();

    protected abstract String getUnitsString();

    protected abstract Unit<?> parseUnit(String var1) throws Exception;

    public final Instant setUnit(Variable other, Unit<?> overwrite) {
        if (other != null) {
            this.unit = other.getUnit();
            this.epoch = other.epoch;
        }
        if (overwrite != null) {
            this.unit = overwrite;
        }
        this.unitParsed = true;
        return this.epoch;
    }

    public final Unit<?> getUnit() {
        if (!this.unitParsed) {
            this.unitParsed = true;
            String symbols = this.getUnitsString();
            if (symbols != null) {
                try {
                    this.unit = this.parseUnit(symbols);
                }
                catch (Exception ex) {
                    this.error(Variable.class, "getUnit", ex, (short)183, this.getName(), symbols);
                }
            }
        }
        return this.unit;
    }

    final boolean hasRealValues() {
        byte n = this.getDataType().number;
        if (n == 8 | n == 9) {
            Convention convention = this.decoder.convention();
            if (convention != Convention.DEFAULT) {
                return convention.transferFunction(this).isIdentity();
            }
            double c = this.getAttributeAsNumber("scale_factor");
            if (Double.isNaN(c) || c == 1.0) {
                c = this.getAttributeAsNumber("add_offset");
                return Double.isNaN(c) || c == 0.0;
            }
        }
        return false;
    }

    public abstract DataType getDataType();

    public final VariableRole getRole() {
        return this.decoder.convention().roleOf(this);
    }

    protected abstract boolean isUnlimited();

    protected abstract boolean isCoordinateSystemAxis();

    protected Grid getGrid(Adjustment adjustment) throws IOException, DataStoreException {
        int i;
        Convention convention = this.decoder.convention();
        ArrayList<Variable> axes = new ArrayList<Variable>();
        HashMap<Object, Dimension> domain = new HashMap<Object, Dimension>();
        for (Variable candidate : this.decoder.getVariables()) {
            if (candidate.getRole() != VariableRole.AXIS) continue;
            axes.add(candidate);
            for (Dimension dim : candidate.getGridDimensions()) {
                domain.put(dim, dim);
            }
        }
        boolean isIncomplete = false;
        List<Dimension> fromVariable = this.getGridDimensions();
        Dimension[] dimensions = fromVariable.toArray(new Dimension[fromVariable.size()]);
        for (i = 0; i < dimensions.length; ++i) {
            dimensions[i] = (Dimension)domain.remove(dimensions[i]);
            isIncomplete |= dimensions[i] == null;
        }
        if (isIncomplete) {
            for (i = 0; i < dimensions.length; ++i) {
                Dimension gridDimension;
                if (dimensions[i] != null) continue;
                String label = convention.nameOfDimension(this, i);
                if (label == null) {
                    return null;
                }
                if (isIncomplete) {
                    isIncomplete = false;
                    if (adjustment.mapLabelToGridDimensions(this, axes, domain, convention)) {
                        return null;
                    }
                }
                Dimension varDimension = fromVariable.get(i);
                dimensions[i] = gridDimension = (Dimension)domain.remove(label);
                if (gridDimension == null) {
                    this.warning(Variable.class, "getGridGeometry", (short)15, this.getFilename(), this.getName(), label);
                    return null;
                }
                if (adjustment.gridToVariable.put(gridDimension, varDimension) == null) continue;
                throw new InternalDataStoreException(this.errors().getString((short)27, gridDimension));
            }
        }
        Grid fallback = null;
        boolean fallbackMatches = false;
        String[] axisNames = convention.namesOfAxisVariables(this);
        for (Grid candidate : this.decoder.getGrids()) {
            Grid grid = candidate.forDimensions(dimensions);
            if (grid == null) continue;
            int gridDimension = grid.getSourceDimensions();
            boolean gridMatches = grid.containsAllNamedAxes(axisNames);
            if (gridMatches && gridDimension == dimensions.length) {
                return grid;
            }
            if (!(gridMatches | !fallbackMatches) || gridMatches == fallbackMatches && fallback != null && gridDimension <= fallback.getSourceDimensions()) continue;
            fallbackMatches = gridMatches;
            fallback = grid;
        }
        return fallback;
    }

    public final GridGeometry getGridGeometry() throws IOException, DataStoreException {
        if (!this.gridDetermined) {
            this.gridDetermined = true;
            GridMapping gridMapping = GridMapping.forVariable(this);
            Adjustment adjustment = new Adjustment();
            Grid info = this.getGrid(adjustment);
            if (info != null) {
                GridGeometry grid;
                List<Dimension> dimensions = this.getGridDimensions();
                int dataDimension = dimensions.size();
                if (dataDimension > info.getSourceDimensions()) {
                    boolean copied = false;
                    List<Dimension> toKeep = info.getDimensions();
                    int numToKeep = toKeep.size();
                    for (int i = 0; i < numToKeep; ++i) {
                        Dimension expected = toKeep.get(i);
                        expected = adjustment.gridToVariable.getOrDefault(expected, expected);
                        while (!expected.equals(dimensions.get(i))) {
                            if (!copied) {
                                copied = true;
                                dimensions = new ArrayList<Dimension>(dimensions);
                            }
                            this.bandDimension = dataDimension - 1 - i;
                            dimensions.remove(i);
                            if (dimensions.size() >= numToKeep) continue;
                            throw new InternalDataStoreException();
                        }
                    }
                }
                if ((grid = info.getGridGeometry(this.decoder)).isDefined(4)) {
                    GridExtent extent = grid.getExtent();
                    long[] sizes = new long[extent.getDimension()];
                    boolean needsResize = false;
                    int i = sizes.length;
                    while (--i >= 0) {
                        int d = sizes.length - 1 - i;
                        sizes[i] = dimensions.get(d).length();
                        if (needsResize) continue;
                        needsResize = sizes[i] != extent.getSize(i);
                    }
                    if (needsResize) {
                        double[] dataToGridIndices = adjustment.dataToGridIndices();
                        if (dataToGridIndices == null || dataToGridIndices.length < sizes.length) {
                            this.warning(Variable.class, "getGridGeometry", (short)17, this.getFilename(), this.getName());
                            return null;
                        }
                        extent = extent.resize(sizes);
                        grid = grid.derive().resize(extent, dataToGridIndices).build();
                    }
                }
                if (gridMapping != null) {
                    grid = gridMapping.adaptGridCRS(this, grid, info.getAnchor());
                }
                this.gridGeometry = grid;
            } else if (gridMapping != null) {
                this.gridGeometry = gridMapping.createGridCRS(this);
            }
        }
        return this.gridGeometry;
    }

    final long getBandStride() throws IOException, DataStoreException {
        long length = 1L;
        GridExtent extent = this.getGridGeometry().getExtent();
        int i = this.bandDimension;
        while (--i >= 0) {
            length = Math.multiplyExact(length, extent.getSize(i));
        }
        return length;
    }

    public abstract List<Dimension> getGridDimensions();

    final NumberRange<?> getValidRange() {
        NumberRange<?> range = this.decoder.convention().validRange(this);
        if (range == null) {
            range = this.getRangeFallback();
        }
        return range;
    }

    protected NumberRange<?> getRangeFallback() {
        int size;
        DataType dataType = this.getDataType();
        if (dataType.isInteger && (size = dataType.size() * 8) > 0 && size <= 64) {
            long min = 0L;
            long max = Numerics.bitmask(size) - 1L;
            if (!dataType.isUnsigned) {
                min = (max >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            for (Number value : this.getNodataValues().keySet()) {
                long n = value.longValue();
                long \u0394min = n - min;
                long \u0394max = max - n;
                if (\u0394min < 0L || \u0394max < 0L) continue;
                if (\u0394min < \u0394max) {
                    min = n + 1L;
                    continue;
                }
                max = n - 1L;
            }
            if (max > min) {
                if (min >= Integer.MIN_VALUE && max <= Integer.MAX_VALUE) {
                    return NumberRange.create((int)min, true, (int)max, true);
                }
                return NumberRange.create(min, true, max, true);
            }
        }
        return null;
    }

    final Map<Number, Object> getNodataValues() {
        if (this.nodataValues == null) {
            this.nodataValues = CollectionsExt.unmodifiableOrCopy(this.decoder.convention().nodataValues(this));
        }
        return this.nodataValues;
    }

    final TransferFunction getTransferFunction() {
        return this.decoder.convention().transferFunction(this);
    }

    public abstract Vector read() throws IOException, DataStoreException;

    public abstract Vector read(GridExtent var1, int[] var2) throws IOException, DataStoreException;

    protected static Vector createDecimalVector(Object data, boolean isUnsigned) {
        if (data instanceof float[]) {
            return Vector.createForDecimal((float[])data);
        }
        return Vector.create(data, isUnsigned);
    }

    protected final void replaceNaN(Object array) {
        if (this.hasRealValues()) {
            int ordinal = 0;
            for (Number value : this.getNodataValues().keySet()) {
                float pad = MathFunctions.toNanFloat(ordinal++);
                if (array instanceof float[]) {
                    ArraysExt.replace((float[])array, value.floatValue(), pad);
                    continue;
                }
                if (!(array instanceof double[])) continue;
                ArraysExt.replace((double[])array, value.doubleValue(), (double)pad);
            }
        }
    }

    protected abstract double coordinateForAxis(int var1, int var2) throws IOException, DataStoreException;

    protected boolean trySetTransform(Matrix gridToCRS, int srcDim, int tgtDim, Vector values) throws IOException, DataStoreException {
        int n = values.size() - 1;
        if (n >= 0) {
            Number increment;
            double first = values.doubleValue(0);
            if (n >= 1) {
                double last = values.doubleValue(n);
                double error = this.getDataType() == DataType.FLOAT ? (double)Math.max(Math.ulp((float)first), Math.ulp((float)last)) : Math.max(Math.ulp(first), Math.ulp(last));
                error = Math.max(Math.ulp(last - first), error) / (double)n;
                increment = values.increment(error);
            } else {
                increment = Double.NaN;
            }
            if (increment != null) {
                gridToCRS.setElement(tgtDim, srcDim, ((Number)increment).doubleValue());
                gridToCRS.setElement(tgtDim, gridToCRS.getNumCol() - 1, first);
                return true;
            }
        }
        return false;
    }

    public final void writeDataTypeName(StringBuilder buffer) {
        buffer.append(this.getDataType().name().toLowerCase(Locale.US));
        List<Dimension> dimensions = this.getGridDimensions();
        int i = dimensions.size();
        while (--i >= 0) {
            dimensions.get(i).writeLength(buffer);
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getName()).append(" : ");
        this.writeDataTypeName(buffer);
        if (this.isUnlimited()) {
            buffer.append(" (unlimited)");
        }
        return buffer.toString();
    }

    protected static final class Adjustment {
        private double[] gridToDataIndices;
        final Map<Dimension, Dimension> gridToVariable = new HashMap<Dimension, Dimension>();

        private Adjustment() {
        }

        boolean mapLabelToGridDimensions(Variable variable, List<Variable> axes, Map<Object, Dimension> toGridDimensions, Convention convention) {
            HashSet<Dimension> requestedByConvention = new HashSet<Dimension>();
            String[] namesOfAxisVariables = convention.namesOfAxisVariables(variable);
            for (Variable axis : axes) {
                boolean isRequested = ArraysExt.containsIgnoreCase(namesOfAxisVariables, axis.getName());
                List<Dimension> candidates = axis.getGridDimensions();
                int j = candidates.size();
                while (--j >= 0) {
                    boolean overwrite;
                    String name;
                    Dimension dim = candidates.get(j);
                    if (!toGridDimensions.containsKey(dim) || (name = convention.nameOfDimension(axis, j)) == null) continue;
                    if (this.gridToDataIndices == null) {
                        this.gridToDataIndices = new double[axes.size()];
                    }
                    this.gridToDataIndices[j] = convention.gridToDataIndices(axis);
                    boolean bl = overwrite = isRequested && requestedByConvention.add(dim);
                    Dimension previous = toGridDimensions.put(name, dim);
                    if (previous == null || previous.equals(dim) || overwrite) continue;
                    if (!isRequested && requestedByConvention.contains(dim)) {
                        toGridDimensions.put(name, previous);
                        continue;
                    }
                    variable.error(Variable.class, "getGridGeometry", null, (short)25, name);
                    return true;
                }
            }
            return false;
        }

        double[] dataToGridIndices() {
            double[] dataToGridIndices = null;
            if (this.gridToDataIndices != null) {
                int i = this.gridToDataIndices.length;
                while (--i >= 0) {
                    double s = this.gridToDataIndices[i];
                    if (s > 0.0 && s != Double.POSITIVE_INFINITY) {
                        if (dataToGridIndices == null) {
                            dataToGridIndices = new double[i + 1];
                        }
                        dataToGridIndices[i] = 1.0 / s;
                        continue;
                    }
                    dataToGridIndices = null;
                }
            }
            return dataToGridIndices;
        }
    }
}

