/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.awt.image.DataBuffer;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.internal.coverage.RasterFactory;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.netcdf.DataType;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.Raster;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.VariableRole;
import org.apache.sis.internal.storage.AbstractGridResource;
import org.apache.sis.internal.storage.ResourceOnFileSystem;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.Resource;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.GenericName;

public final class RasterResource
extends AbstractGridResource
implements ResourceOnFileSystem {
    private static final String[] VECTOR_COMPONENT_NAMES = new String[]{"eastward", "westward", "northward", "southward", "upward", "downward"};
    private GenericName identifier;
    private final GridGeometry gridGeometry;
    private final SampleDimension[] ranges;
    private final Variable[] data;
    private final int bandDimension;
    private final Path location;
    private final Object lock;

    private RasterResource(Decoder decoder, String name, GridGeometry grid, List<Variable> bands, int numBands, int bandDim, Object lock) {
        super(decoder.listeners);
        this.data = bands.toArray(new Variable[bands.size()]);
        this.ranges = new SampleDimension[numBands];
        this.identifier = decoder.nameFactory.createLocalName(decoder.namespace, name);
        this.location = decoder.location;
        this.gridGeometry = grid;
        this.bandDimension = bandDim;
        this.lock = lock;
        assert (this.data.length == (this.bandDimension >= 0 ? 1 : this.ranges.length));
    }

    public static List<Resource> create(Decoder decoder, Object lock) throws IOException, DataStoreException {
        assert (Thread.holdsLock(lock));
        Variable[] variables = (Variable[])decoder.getVariables().clone();
        ArrayList<Variable> siblings = new ArrayList<Variable>(4);
        ArrayList<Resource> resources = new ArrayList<Resource>(variables.length);
        HashMap<GenericName, RasterResource> firstOfName = new HashMap<GenericName, RasterResource>();
        for (int i = 0; i < variables.length; ++i) {
            int numBands;
            int bandDimension;
            GridGeometry grid;
            Variable variable = variables[i];
            if (variable == null || variable.getRole() != VariableRole.COVERAGE || (grid = variable.getGridGeometry()) == null) continue;
            siblings.add(variable);
            String name = variable.getStandardName();
            List<Dimension> gridDimensions = variable.getGridDimensions();
            int dataDimension = gridDimensions.size();
            int gridDimension = grid.getDimension();
            if (dataDimension != gridDimension) {
                bandDimension = variable.bandDimension;
                Dimension dim = gridDimensions.get(dataDimension - 1 - bandDimension);
                numBands = Math.toIntExact(dim.length());
                if (dataDimension != gridDimension + 1 || bandDimension > 0 && bandDimension != gridDimension) {
                    throw new DataStoreContentException(Resources.forLocale(decoder.listeners.getLocale()).getString((short)19, name, decoder.getFilename(), dataDimension, gridDimension));
                }
            } else {
                bandDimension = -1;
                DataType type = variable.getDataType();
                for (String keyword : VECTOR_COMPONENT_NAMES) {
                    int prefixLength = name.indexOf(keyword);
                    if (prefixLength < 0) continue;
                    int suffixStart = prefixLength + keyword.length();
                    int suffixLength = name.length() - suffixStart;
                    int j = i;
                    block2: while (++j < variables.length) {
                        Variable candidate = variables[j];
                        if (candidate == null || candidate.getRole() != VariableRole.COVERAGE) {
                            variables[j] = null;
                            continue;
                        }
                        String cn = candidate.getStandardName();
                        if (!cn.regionMatches(cn.length() - suffixLength, name, suffixStart, suffixLength) || !cn.regionMatches(0, name, 0, prefixLength) || candidate.getDataType() != type || !grid.equals(candidate.getGridGeometry())) continue;
                        for (String k : VECTOR_COMPONENT_NAMES) {
                            if (!cn.regionMatches(prefixLength, k, 0, k.length())) continue;
                            siblings.add(candidate);
                            variables[j] = null;
                            continue block2;
                        }
                    }
                    if (siblings.size() <= 1) continue;
                    if (suffixLength != 0) {
                        int c = name.codePointAt(suffixStart);
                        if (prefixLength != 0 ? c == name.codePointBefore(prefixLength) : c == 95) {
                            suffixStart += Character.charCount(c);
                        }
                    }
                    name = new StringBuilder(name).delete(prefixLength, suffixStart).toString();
                }
                numBands = siblings.size();
            }
            RasterResource r = new RasterResource(decoder, name.trim(), grid, siblings, numBands, bandDimension, lock);
            r.resolveNameCollision(firstOfName.putIfAbsent(r.identifier, r), decoder);
            resources.add(r);
            siblings.clear();
        }
        return resources;
    }

    private void resolveNameCollision(RasterResource other, Decoder decoder) {
        if (other != null) {
            if (this.identifier.equals(other.identifier)) {
                other.resolveNameCollision(decoder);
            }
            this.resolveNameCollision(decoder);
        }
    }

    private void resolveNameCollision(Decoder decoder) {
        String name = this.identifier + " (" + this.data[0].getName() + ')';
        this.identifier = decoder.nameFactory.createLocalName(decoder.namespace, name);
    }

    @Override
    public Optional<GenericName> getIdentifier() {
        return Optional.of(this.identifier);
    }

    @Override
    public GridGeometry getGridGeometry() {
        return this.gridGeometry;
    }

    private Variable getVariable(int i) {
        return this.data[this.bandDimension >= 0 ? 0 : i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SampleDimension> getSampleDimensions() throws DataStoreException {
        SampleDimension.Builder builder = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                for (int i = 0; i < this.ranges.length; ++i) {
                    if (this.ranges[i] != null) continue;
                    if (builder == null) {
                        builder = new SampleDimension.Builder();
                    }
                    this.ranges[i] = this.createSampleDimension(builder, this.getVariable(i), i);
                    builder.clear();
                }
            }
        }
        catch (TransformException e) {
            throw new DataStoreReferencingException(e);
        }
        return UnmodifiableArrayList.wrap(this.ranges);
    }

    private SampleDimension createSampleDimension(SampleDimension.Builder builder, Variable band, int index) throws TransformException {
        NumberRange<Object> range;
        if (!RasterResource.createEnumeration(builder, band, index) && (range = band.getValidRange()) != null) {
            MathTransform1D mt = band.getTransferFunction().getTransform();
            if (!mt.isIdentity() && range instanceof MeasurementRange) {
                MathTransform1D inverse = mt.inverse();
                boolean isMinIncluded = range.isMinIncluded();
                boolean isMaxIncluded = range.isMaxIncluded();
                double minimum = inverse.transform(range.getMinDouble());
                double maximum = inverse.transform(range.getMaxDouble());
                if (maximum < minimum) {
                    double swap = maximum;
                    maximum = minimum;
                    minimum = swap;
                    boolean sb = isMaxIncluded;
                    isMaxIncluded = isMinIncluded;
                    isMinIncluded = sb;
                }
                range = band.getDataType().number <= 6 && minimum >= -9.223372036854776E18 && maximum <= 9.223372036854776E18 ? NumberRange.create(Math.round(minimum), isMinIncluded, Math.round(maximum), isMaxIncluded) : NumberRange.create(minimum, isMinIncluded, maximum, isMaxIncluded);
            }
            if (range.isEmpty()) {
                band.warning(RasterResource.class, "getSampleDimensions", (short)16, band.getFilename(), band.getName(), range.getMinValue(), range.getMaxValue());
            } else {
                String name = band.getDescription();
                if (name == null) {
                    name = band.getName();
                }
                builder.addQuantitative((CharSequence)name, range, mt, band.getUnit());
            }
        }
        boolean setBackground = true;
        int ordinal = band.hasRealValues() ? 0 : -1;
        CharSequence[] names = new CharSequence[2];
        for (Map.Entry<Number, Object> entry : band.getNodataValues().entrySet()) {
            CharSequence name;
            Number n = ordinal >= 0 ? (Number)Float.valueOf(MathFunctions.toNanFloat(ordinal++)) : (Number)entry.getKey();
            Object label = entry.getValue();
            if (label instanceof Integer) {
                int role = (Integer)label;
                int i = role == 1 ? 1 : 0;
                name = names[i];
                if (name == null) {
                    names[i] = name = Vocabulary.formatInternational(i == 0 ? (short)160 : 159);
                }
                if (setBackground & (role & 1) != 0) {
                    setBackground = false;
                    builder.setBackground(name, n);
                    continue;
                }
            } else {
                name = (CharSequence)label;
            }
            builder.addQualitative(name, n, n);
        }
        String name = band.getName();
        if (this.bandDimension >= 0) {
            name = Strings.toIndexed(name, index);
        }
        return builder.setName(name).build();
    }

    private static boolean createEnumeration(SampleDimension.Builder builder, Variable band, int index) {
        CharSequence[] names = band.getAttributeAsStrings("flag_names", ' ');
        if (names == null && (names = band.getAttributeAsStrings("flag_meanings", ' ')) == null) {
            return false;
        }
        Vector values = band.getAttributeAsVector("flag_values");
        if (values == null && (values = band.getAttributeAsVector("flag_masks")) == null) {
            return false;
        }
        int length = values.size();
        for (int i = 0; i < length; ++i) {
            Number value = values.get(i);
            Object name = i < names.length ? names[i] : Vocabulary.formatInternational((short)108);
            builder.addQualitative((CharSequence)name, value, value);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridCoverage read(GridGeometry domain, int ... range) throws DataStoreException {
        DataBuffer imageBuffer;
        AbstractGridResource.RangeArgument rangeIndices = this.validateRangeArgument(this.ranges.length, range);
        if (domain == null) {
            domain = this.gridGeometry;
        }
        Variable first = this.data[this.bandDimension >= 0 ? 0 : rangeIndices.getFirstSpecified()];
        DataType dataType = first.getDataType();
        if (this.bandDimension < 0) {
            for (int i = 0; i < rangeIndices.getNumBands(); ++i) {
                Variable variable = this.data[rangeIndices.getSourceIndex(i)];
                if (dataType.equals((Object)variable.getDataType())) continue;
                throw new DataStoreContentException(Resources.forLocale(this.getLocale()).getString((short)13, this.getFilename(), first.getName(), variable.getName()));
            }
        }
        SampleDimension[] bands = new SampleDimension[rangeIndices.getNumBands()];
        int[] bandOffsets = null;
        try {
            GridDerivation targetGeometry = this.gridGeometry.derive().rounding(GridRoundingMode.ENCLOSING).subgrid(domain);
            GridExtent areaOfInterest = targetGeometry.getIntersection();
            int[] subsamplings = targetGeometry.getSubsamplings();
            int numBuffers = bands.length;
            domain = targetGeometry.build();
            if (this.bandDimension >= 0) {
                areaOfInterest = rangeIndices.insertBandDimension(areaOfInterest, this.bandDimension);
                subsamplings = rangeIndices.insertSubsampling(subsamplings, this.bandDimension);
                if (this.bandDimension == 0) {
                    bandOffsets = new int[numBuffers];
                }
                numBuffers = 1;
            }
            Buffer[] sampleValues = new Buffer[numBuffers];
            Object object = this.lock;
            synchronized (object) {
                for (int i = 0; i < bands.length; ++i) {
                    int indexInResource = rangeIndices.getSourceIndex(i);
                    int indexInRaster = rangeIndices.getTargetIndex(i);
                    Variable variable = this.getVariable(indexInResource);
                    SampleDimension b = this.ranges[indexInResource];
                    if (b == null) {
                        this.ranges[indexInResource] = b = this.createSampleDimension(rangeIndices.builder(), variable, i);
                    }
                    bands[indexInRaster] = b;
                    if (bandOffsets != null) {
                        bandOffsets[indexInRaster] = i;
                        indexInRaster = 0;
                    }
                    if (i >= numBuffers) continue;
                    sampleValues[indexInRaster] = variable.read(areaOfInterest, subsamplings).buffer().get();
                }
            }
            if (this.bandDimension > 0) {
                int stride = Math.toIntExact(this.data[0].getBandStride());
                Buffer values = sampleValues[0].limit(stride);
                sampleValues = new Buffer[bands.length];
                for (int i = 0; i < sampleValues.length; ++i) {
                    if (i != 0) {
                        values = JDK9.duplicate(values);
                        int p = values.limit();
                        values.position(p).limit(Math.addExact(p, stride));
                    }
                    sampleValues[i] = values;
                }
            }
            imageBuffer = RasterFactory.wrap(dataType.rasterDataType, sampleValues);
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        catch (TransformException e) {
            throw new DataStoreReferencingException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TransformException) {
                throw new DataStoreReferencingException(cause);
            }
            throw new DataStoreContentException(e);
        }
        if (imageBuffer == null) {
            throw new DataStoreContentException(Errors.getResources(this.getLocale()).getString((short)163, dataType.name()));
        }
        return new Raster(domain, UnmodifiableArrayList.wrap(bands), imageBuffer, rangeIndices.getPixelStride(), bandOffsets, String.valueOf(this.identifier));
    }

    private String getFilename() {
        if (this.location != null) {
            return this.location.getFileName().toString();
        }
        return Vocabulary.getResources(this.getLocale()).getString((short)108);
    }

    @Override
    public Path[] getComponentFiles() {
        Path[] pathArray;
        if (this.location != null) {
            Path[] pathArray2 = new Path[1];
            pathArray = pathArray2;
            pathArray2[0] = this.location;
        } else {
            pathArray = new Path[]{};
        }
        return pathArray;
    }
}

