/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.netcdf.Resources;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.resources.IndexedResourceBundle;

public abstract class NamedElement {
    protected NamedElement() {
    }

    public abstract String getName();

    public String getGroupName() {
        return null;
    }

    protected static String listNames(NamedElement[] components, int count, String delimiter) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (int i = 0; i < count; ++i) {
            joiner.add(components[i].getName());
        }
        return joiner.toString();
    }

    protected static boolean similar(CharSequence s1, CharSequence s2) {
        return CharSequences.equalsFiltered(s1, s2, Characters.Filter.UNICODE_IDENTIFIER, true);
    }

    static void warning(StoreListeners listeners, Class<?> caller, String method, Exception exception, IndexedResourceBundle resources, short key, Object ... arguments) {
        if (resources == null) {
            resources = Resources.forLocale(listeners.getLocale());
        }
        LogRecord record = resources.getLogRecord(Level.WARNING, key, arguments);
        record.setLoggerName("org.apache.sis.storage.netcdf");
        record.setSourceClassName(caller.getCanonicalName());
        record.setSourceMethodName(method);
        if (exception != null) {
            record.setThrown(exception);
        }
        listeners.warning(record);
    }

    public String toString() {
        return Strings.bracket(this.getClass().getSimpleName(), (Object)this.getName());
    }
}

