/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.util.HashMap;
import java.util.Set;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.SatelliteGroundTrack;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.referencing.operation.builder.LocalizationGridBuilder;
import org.apache.sis.util.logging.Logging;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public enum Linearizer {
    MERCATOR("Mercator (Spherical)"),
    GROUND_TRACK(null);

    private String projection;
    private MathTransform transform;

    private Linearizer(String projection) {
        this.projection = projection;
    }

    private synchronized MathTransform transform() {
        String p = this.projection;
        if (p != null) {
            this.projection = null;
            MathTransformFactory factory = DefaultFactories.forClass(MathTransformFactory.class);
            if (factory != null) {
                try {
                    ParameterValueGroup pg = factory.getDefaultParameters(p);
                    pg.parameter("semi_major").setValue(6371007.0);
                    pg.parameter("semi_minor").setValue(6371007.0);
                    this.transform = factory.createParameterizedTransform(pg);
                }
                catch (FactoryException e) {
                    Linearizer.warning((Exception)((Object)e));
                }
            }
        }
        return this.transform;
    }

    static void applyTo(Set<Linearizer> linearizers, MathTransformFactory factory, LocalizationGridBuilder grid, Axis ... axes) {
        int xdim = -1;
        int ydim = -1;
        int i = axes.length;
        while (--i >= 0) {
            switch (axes[i].abbreviation) {
                case '\u03bb': {
                    xdim = i;
                    break;
                }
                case '\u03c6': {
                    ydim = i;
                }
            }
        }
        if (xdim >= 0 && ydim >= 0) {
            HashMap<String, MathTransform> projections = new HashMap<String, MathTransform>();
            for (Linearizer linearizer : linearizers) {
                MathTransform transform;
                switch (linearizer) {
                    default: {
                        transform = linearizer.transform();
                        break;
                    }
                    case GROUND_TRACK: {
                        int direction = axes[ydim].getMainDirection();
                        direction ^= 1;
                        try {
                            transform = SatelliteGroundTrack.create(factory, grid, xdim, direction);
                        }
                        catch (TransformException | FactoryException e) {
                            transform = null;
                            Linearizer.warning((Exception)e);
                        }
                        break;
                    }
                }
                if (transform == null) continue;
                projections.put(linearizer.name(), transform);
            }
            grid.addLinearizers(projections, xdim, ydim);
        }
    }

    private static void warning(Exception e) {
        Logging.unexpectedException(Logging.getLogger("org.apache.sis.storage.netcdf"), Variable.class, "getGridGeometry", e);
    }
}

