/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.netcdf.Node;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.GeodeticObjectBuilder;
import org.apache.sis.internal.referencing.j2d.AffineTransform2D;
import org.apache.sis.internal.referencing.provider.PseudoPlateCarree;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class GridMapping {
    final CoordinateReferenceSystem crs;
    private final MathTransform gridToCRS;
    private final boolean isEPSG;

    private GridMapping(CoordinateReferenceSystem crs, MathTransform gridToCRS, boolean isEPSG) {
        this.crs = crs;
        this.gridToCRS = gridToCRS;
        this.isEPSG = isEPSG;
    }

    static GridMapping forVariable(Variable variable) {
        Map<Object, GridMapping> gridMapping = variable.decoder.gridMapping;
        for (String name : variable.decoder.convention().nameOfMappingNode(variable)) {
            GridMapping gm = gridMapping.get(name);
            if (gm != null) {
                return gm;
            }
            if (gridMapping.containsKey(name)) continue;
            Node mapping = variable.decoder.findNode(name);
            if (mapping != null) {
                gm = GridMapping.parse(mapping);
            }
            gridMapping.put(name, gm);
            if (gm == null) continue;
            return gm;
        }
        GridMapping gm = gridMapping.get(variable);
        if (gm == null) {
            String name;
            name = variable.getName();
            gm = gridMapping.get(name);
            if (gm == null && !gridMapping.containsKey(name)) {
                gm = GridMapping.parse(variable);
                gridMapping.put(name, gm);
            }
            if (gm == null) {
                gm = GridMapping.parseNonStandard(variable);
            }
            if (gm != null) {
                gridMapping.put(variable, gm);
            }
        }
        return gm;
    }

    private static GridMapping parse(Node mapping) {
        GridMapping gm = GridMapping.parseProjectionParameters(mapping);
        if (gm == null) {
            gm = GridMapping.parseGeoTransform(mapping);
        }
        return gm;
    }

    private static GridMapping parseProjectionParameters(Node node) {
        Map<String, Object> definition = node.decoder.convention().projection(node);
        if (definition != null) {
            try {
                GeographicCRS crs;
                LinearTransform baseToCRS;
                Object greenwichLongitude = definition.remove("longitude_of_prime_meridian");
                DefaultCoordinateOperationFactory opFactory = node.decoder.getCoordinateOperationFactory();
                OperationMethod method = opFactory.getOperationMethod((String)definition.remove("grid_mapping_name"));
                ParameterValueGroup parameters = method.getParameters().createValue();
                for (Map.Entry<String, Object> entry : definition.entrySet()) {
                    String name = entry.getKey();
                    Object value = entry.getValue();
                    if (!(value instanceof Number) && !(value instanceof double[]) && !(value instanceof float[])) continue;
                    try {
                        parameters.parameter(name).setValue(value);
                    }
                    catch (IllegalArgumentException ex) {
                        GridMapping.warning(node, ex, (short)20, node.decoder.getFilename(), node.getName(), name, value, ex.getLocalizedMessage());
                    }
                }
                GeographicCRS baseCRS = GridMapping.createBaseCRS(node.decoder, parameters, definition, greenwichLongitude);
                if (method instanceof PseudoPlateCarree) {
                    baseToCRS = MathTransforms.linear(new Matrix3(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0));
                    crs = baseCRS;
                } else {
                    Map<String, Object> properties = GridMapping.properties(definition, "conversion_name", node.getName());
                    Conversion conversion = opFactory.createDefiningConversion(properties, method, parameters);
                    CartesianCS cs = node.decoder.getStandardProjectedCS();
                    properties = GridMapping.properties(definition, "projected_crs_name", conversion);
                    ProjectedCRS p = node.decoder.getCRSFactory().createProjectedCRS(properties, baseCRS, conversion, cs);
                    baseToCRS = p.getConversionFromBase().getMathTransform();
                    crs = p;
                }
                MathTransform gridToCRS = node.decoder.convention().gridToCRS(node, baseToCRS);
                return new GridMapping((CoordinateReferenceSystem)crs, gridToCRS, false);
            }
            catch (ClassCastException | IllegalArgumentException | TransformException | FactoryException e) {
                GridMapping.canNotCreate(node, (short)11, (Exception)e);
            }
        }
        return null;
    }

    private static GeographicCRS createBaseCRS(Decoder decoder, ParameterValueGroup parameters, Map<String, Object> definition, Object greenwichLongitude) throws FactoryException {
        GeodeticDatum datum;
        Ellipsoid ellipsoid;
        Map<String, Object> properties;
        PrimeMeridian meridian;
        DatumFactory datumFactory = decoder.getDatumFactory();
        CommonCRS defaultDefinitions = decoder.convention().defaultHorizontalCRS(false);
        boolean isSpecified = false;
        if (greenwichLongitude instanceof Number) {
            double longitude = ((Number)greenwichLongitude).doubleValue();
            Map<String, Object> properties2 = GridMapping.properties(definition, "prime_meridian_name", null);
            meridian = datumFactory.createPrimeMeridian(properties2, longitude, Units.DEGREE);
            isSpecified = true;
        } else {
            meridian = defaultDefinitions.primeMeridian();
        }
        try {
            double semiMajor = parameters.parameter("semi_major").doubleValue();
            properties = GridMapping.properties(definition, "reference_ellipsoid_name", null);
            if (parameters.parameter("is_ivf_definitive").booleanValue()) {
                double ivf = parameters.parameter("inverse_flattening").doubleValue();
                ellipsoid = datumFactory.createFlattenedSphere(properties, semiMajor, ivf, Units.METRE);
            } else {
                double semiMinor = parameters.parameter("semi_minor").doubleValue();
                ellipsoid = datumFactory.createEllipsoid(properties, semiMajor, semiMinor, Units.METRE);
            }
            isSpecified = true;
        }
        catch (IllegalStateException | ParameterNotFoundException e) {
            ellipsoid = defaultDefinitions.ellipsoid();
        }
        Object bursaWolf = definition.remove("towgs84");
        if (isSpecified | bursaWolf != null) {
            properties = GridMapping.properties(definition, "horizontal_datum_name", ellipsoid);
            if (bursaWolf instanceof BursaWolfParameters) {
                properties = new HashMap<String, Object>(properties);
                properties.put("bursaWolf", bursaWolf);
                isSpecified = true;
            }
            datum = datumFactory.createGeodeticDatum(properties, ellipsoid, meridian);
        } else {
            datum = defaultDefinitions.datum();
        }
        if (isSpecified) {
            properties = GridMapping.properties(definition, "geographic_crs_name", datum);
            return decoder.getCRSFactory().createGeographicCRS(properties, datum, defaultDefinitions.geographic().getCoordinateSystem());
        }
        return defaultDefinitions.geographic();
    }

    private static Map<String, Object> properties(Map<String, Object> definition, String nameAttribute, Object fallback) {
        Object name = definition.remove(nameAttribute);
        if (name == null) {
            name = fallback instanceof IdentifiedObject ? ((IdentifiedObject)fallback).getName() : (fallback != null ? fallback : Vocabulary.formatInternational((short)108));
        }
        return Collections.singletonMap("name", name);
    }

    private static GridMapping parseGeoTransform(Node mapping) {
        String wkt = mapping.getAttributeAsString("spatial_ref");
        String gtr = mapping.getAttributeAsString("GeoTransform");
        if (wkt == null && gtr == null) {
            return null;
        }
        short message = 11;
        CoordinateReferenceSystem crs = null;
        AffineTransform2D gridToCRS = null;
        try {
            if (wkt != null) {
                crs = GridMapping.createFromWKT(mapping, wkt);
            }
            if (gtr != null) {
                message = 12;
                double[] c = CharSequences.parseDoubles(gtr, ' ');
                if (c.length == 6) {
                    gridToCRS = new AffineTransform2D(c[1], c[4], c[2], c[5], c[0], c[3]);
                } else {
                    GridMapping.canNotCreate(mapping, message, new DataStoreContentException(Errors.getResources(mapping.getLocale()).getString((short)133, 6, c.length)));
                }
            }
        }
        catch (NumberFormatException | ParseException e) {
            GridMapping.canNotCreate(mapping, message, e);
        }
        return new GridMapping(crs, gridToCRS, false);
    }

    private static GridMapping parseNonStandard(Node variable) {
        CoordinateReferenceSystem crs;
        boolean isEPSG = false;
        String code = variable.getAttributeAsString("ESRI_pe_string");
        if (code == null) {
            code = variable.getAttributeAsString("EPSG_code");
            if (code == null) {
                return null;
            }
            isEPSG = true;
        }
        try {
            crs = isEPSG ? CRS.forCode("EPSG:" + isEPSG) : GridMapping.createFromWKT(variable, code);
        }
        catch (ClassCastException | ParseException | FactoryException e) {
            GridMapping.canNotCreate(variable, (short)11, (Exception)e);
            crs = null;
        }
        return new GridMapping(crs, null, isEPSG);
    }

    private static CoordinateReferenceSystem createFromWKT(Node node, String wkt) throws ParseException {
        WKTFormat f = new WKTFormat(node.getLocale(), node.decoder.getTimeZone());
        f.setConvention(Convention.WKT1_COMMON_UNITS);
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)f.parseObject(wkt);
        Warnings warnings = f.getWarnings();
        if (warnings != null) {
            LogRecord record = new LogRecord(Level.WARNING, warnings.toString());
            record.setLoggerName("org.apache.sis.storage.netcdf");
            record.setSourceClassName(Variable.class.getCanonicalName());
            record.setSourceMethodName("getGridGeometry");
            node.decoder.listeners.warning(record);
        }
        return crs;
    }

    private static void canNotCreate(Node node, short key, Exception ex) {
        GridMapping.warning(node, ex, key, node.decoder.getFilename(), node.getName(), ex.getLocalizedMessage());
    }

    private static void warning(Node node, Exception ex, short key, Object ... arguments) {
        NamedElement.warning(node.decoder.listeners, Variable.class, "getGridGeometry", ex, null, key, arguments);
    }

    GridGeometry createGridCRS(Variable variable) {
        List<Dimension> dimensions = variable.getGridDimensions();
        long[] upper = new long[dimensions.size()];
        for (int i = 0; i < upper.length; ++i) {
            int d = upper.length - 1 - i;
            upper[i] = dimensions.get(d).length();
        }
        return new GridGeometry(new GridExtent(null, null, upper, false), PixelInCell.CELL_CENTER, this.gridToCRS, this.crs);
    }

    GridGeometry adaptGridCRS(Variable variable, GridGeometry template, PixelInCell anchor) {
        CoordinateReferenceSystem givenCRS = this.crs;
        int firstAffectedCoordinate = 0;
        boolean isSameGrid = true;
        if (template.isDefined(1)) {
            CoordinateReferenceSystem templateCRS = template.getCoordinateReferenceSystem();
            if (givenCRS == null) {
                givenCRS = templateCRS;
            } else {
                CoordinateSystem subCS;
                CoordinateSystem cs = templateCRS.getCoordinateSystem();
                firstAffectedCoordinate = AxisDirections.indexOfColinear(cs, subCS = givenCRS.getCoordinateSystem());
                if (firstAffectedCoordinate < 0 && (firstAffectedCoordinate = AxisDirections.indexOfColinear(cs, subCS = (givenCRS = AbstractCRS.castOrCopy(givenCRS).forConvention(AxesConvention.RIGHT_HANDED)).getCoordinateSystem())) < 0) {
                    firstAffectedCoordinate = 0;
                    if (!this.isEPSG) {
                        givenCRS = this.crs;
                        subCS = givenCRS.getCoordinateSystem();
                    }
                }
                try {
                    givenCRS = new GeodeticObjectBuilder(variable.decoder, variable.decoder.listeners.getLocale()).replaceComponent(templateCRS, firstAffectedCoordinate, givenCRS);
                }
                catch (FactoryException e) {
                    GridMapping.canNotCreate(variable, (short)11, (Exception)((Object)e));
                    return null;
                }
                isSameGrid = templateCRS.equals(givenCRS);
                if (isSameGrid) {
                    givenCRS = templateCRS;
                }
            }
        }
        MathTransform givenG2C = this.gridToCRS;
        if (template.isDefined(8)) {
            MathTransform templateG2C = template.getGridToCRS(anchor);
            if (givenG2C == null) {
                givenG2C = templateG2C;
            } else {
                try {
                    int upper;
                    int count = 0;
                    MathTransform[] components = new MathTransform[3];
                    TransformSeparator sep = new TransformSeparator(templateG2C, variable.decoder.getMathTransformFactory());
                    if (firstAffectedCoordinate != 0) {
                        sep.addTargetDimensionRange(0, firstAffectedCoordinate);
                        components[count++] = sep.separate();
                        sep.clear();
                    }
                    components[count++] = givenG2C;
                    int next = firstAffectedCoordinate + givenG2C.getTargetDimensions();
                    if (next != (upper = templateG2C.getTargetDimensions())) {
                        sep.addTargetDimensionRange(next, upper);
                        components[count++] = sep.separate();
                    }
                    if (templateG2C.equals(givenG2C = MathTransforms.compound(components = ArraysExt.resize(components, count)))) {
                        givenG2C = templateG2C;
                    } else {
                        isSameGrid = false;
                    }
                }
                catch (FactoryException e) {
                    GridMapping.canNotCreate(variable, (short)12, (Exception)((Object)e));
                    return null;
                }
            }
        }
        if (isSameGrid) {
            return template;
        }
        return new GridGeometry(template.getExtent(), anchor, givenG2C, givenCRS);
    }
}

