/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Set;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Linearizer;
import org.apache.sis.internal.storage.io.ByteWriter;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.math.Vector;
import org.apache.sis.util.collection.Cache;
import org.opengis.referencing.operation.MathTransform;

class GridCacheKey {
    private final int width;
    private final int height;
    private final Object xAxis;
    private final Object yAxis;

    GridCacheKey(int width, int height, Axis xAxis, Axis yAxis) {
        this.width = width;
        this.height = height;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
    }

    private GridCacheKey(GridCacheKey keyLocal) {
        this.width = keyLocal.width;
        this.height = keyLocal.height;
        this.xAxis = GridCacheKey.id(keyLocal.xAxis);
        this.yAxis = GridCacheKey.id(keyLocal.yAxis);
    }

    private static Object id(Object axis) {
        return ((Axis)axis).getName();
    }

    final MathTransform cached(Decoder decoder) {
        return decoder.localizationGrids.get(this);
    }

    final MathTransform cache(Decoder decoder, MathTransform grid) {
        MathTransform tr = decoder.localizationGrids.putIfAbsent(this, grid);
        return tr != null ? tr : grid;
    }

    public int hashCode() {
        return 31 * this.width + 37 * this.height + 7 * this.xAxis.hashCode() + this.yAxis.hashCode();
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            GridCacheKey that = (GridCacheKey)other;
            return that.width == this.width && that.height == this.height && this.xAxis.equals(that.xAxis) && this.yAxis.equals(that.yAxis);
        }
        return false;
    }

    public String toString() {
        return Strings.toString(this.getClass(), "width", this.width, "height", this.height);
    }

    static final class Global
    extends GridCacheKey {
        private static final Cache<GridCacheKey, MathTransform> CACHE = new Cache(12, 0L, true);
        private final Set<Linearizer> linearizers;
        private final byte[] digest;

        Global(GridCacheKey keyLocal, Vector vx, Vector vy, Set<Linearizer> linearizers) {
            super(keyLocal);
            MessageDigest md;
            this.linearizers = linearizers;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException(e);
            }
            byte[] buffer = new byte[8192];
            byte[] dx = Global.checksum(md, vx, buffer);
            byte[] dy = Global.checksum(md, vy, buffer);
            this.digest = new byte[dx.length + dy.length];
            System.arraycopy(dx, 0, this.digest, 0, dx.length);
            System.arraycopy(dy, 0, this.digest, dx.length, dy.length);
        }

        private static byte[] checksum(MessageDigest md, Vector vector, byte[] buffer) {
            int n;
            ByteWriter writer = ByteWriter.create(vector, buffer);
            while ((n = writer.write()) > 0) {
                md.update(buffer, 0, n);
            }
            return md.digest();
        }

        final Cache.Handler<MathTransform> lock() {
            return CACHE.lock(this);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.linearizers.hashCode() + Arrays.hashCode(this.digest);
        }

        @Override
        public boolean equals(Object other) {
            if (super.equals(other)) {
                Global that = (Global)other;
                if (this.linearizers.equals(that.linearizers)) {
                    return Arrays.equals(this.digest, that.digest);
                }
            }
            return false;
        }
    }
}

