/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.internal.netcdf.Axis;
import org.apache.sis.internal.netcdf.CRSBuilder;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.Dimension;
import org.apache.sis.internal.netcdf.NamedElement;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.NullArgumentException;
import org.opengis.metadata.spatial.DimensionNameType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.FactoryException;

public abstract class Grid
extends NamedElement {
    public static final int MIN_DIMENSION = 2;
    static final int MIN_SPAN = 2;
    private Axis[] axes;
    private CoordinateReferenceSystem crs;
    private boolean isCRSDetermined;
    private GridGeometry geometry;
    private boolean isGeometryDetermined;
    private PixelInCell anchor = PixelInCell.CELL_CENTER;

    protected Grid() {
    }

    protected abstract Grid forDimensions(Dimension[] var1);

    public abstract int getSourceDimensions();

    public abstract int getTargetDimensions();

    protected abstract List<Dimension> getDimensions();

    public final Axis[] getAxes(Decoder decoder) throws IOException, DataStoreException {
        if (this.axes == null) {
            this.axes = this.createAxes(decoder);
            Axis[] workspace = new Axis[this.axes.length];
            int i = 0;
            int deferred = workspace.length;
            Axis[] axisArray = this.axes;
            int n = axisArray.length;
            for (int j = 0; j < n; ++j) {
                Axis axis;
                workspace[(axis = axisArray[j]).getDimension() <= 1 ? i++ : --deferred] = axis;
            }
            deferred = workspace.length;
            while (i < workspace.length) {
                Axis axis = workspace[i];
                if (i < deferred && axis.isWraparound()) {
                    System.arraycopy(workspace, i + 1, workspace, i, --deferred - i);
                    workspace[deferred] = axis;
                    continue;
                }
                axis.mainDimensionFirst(workspace, i);
                ++i;
            }
        }
        return this.axes;
    }

    protected abstract Axis[] createAxes(Decoder var1) throws IOException, DataStoreException;

    protected abstract boolean containsAllNamedAxes(String[] var1);

    final CoordinateReferenceSystem getCoordinateReferenceSystem(Decoder decoder, List<Exception> warnings) throws IOException, DataStoreException {
        block9: {
            if (!this.isCRSDetermined) {
                try {
                    this.isCRSDetermined = true;
                    ArrayList builders = new ArrayList();
                    for (Axis axis : this.getAxes(decoder)) {
                        CRSBuilder.dispatch(builders, axis);
                    }
                    SingleCRS[] components = new SingleCRS[builders.size()];
                    for (int i = 0; i < components.length; ++i) {
                        components[i] = ((CRSBuilder)builders.get(i)).build(decoder);
                    }
                    switch (components.length) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.crs = components[0];
                            break;
                        }
                        default: {
                            this.crs = decoder.getCRSFactory().createCompoundCRS(Collections.singletonMap("name", this.getName()), (CoordinateReferenceSystem[])components);
                            break;
                        }
                    }
                }
                catch (NullArgumentException | FactoryException ex) {
                    if (!Grid.isNewWarning((Exception)ex, warnings)) break block9;
                    this.canNotCreate(decoder, "getCoordinateReferenceSystem", (short)11, (Exception)ex);
                }
            }
        }
        return this.crs;
    }

    private static boolean isNewWarning(Exception ex, List<Exception> warnings) {
        if (warnings != null) {
            for (Exception previous : warnings) {
                if (!Exceptions.messageEquals(ex, previous)) continue;
                return false;
            }
            warnings.add(ex);
        }
        return true;
    }

    private GridExtent getExtent(Axis[] axes) {
        List<Dimension> dimensions = this.getDimensions();
        int n = dimensions.size();
        long[] high = new long[n];
        for (int i = 0; i < n; ++i) {
            long length = dimensions.get(i).length();
            if (length <= 0L) {
                return null;
            }
            high[n - 1 - i] = length;
        }
        DimensionNameType[] names = new DimensionNameType[n];
        switch (n) {
            default: {
                names[1] = DimensionNameType.ROW;
            }
            case 1: {
                names[0] = DimensionNameType.COLUMN;
            }
            case 0: 
        }
        for (Axis axis : axes) {
            DimensionNameType name;
            if (axis.getDimension() != 1) continue;
            if (AxisDirections.isVertical(axis.direction)) {
                name = DimensionNameType.VERTICAL;
            } else {
                if (!AxisDirections.isTemporal(axis.direction)) continue;
                name = DimensionNameType.TIME;
            }
            int dim = axis.sourceDimensions[0];
            dim = names.length - 1 - dim;
            if (dim < 0) continue;
            names[dim] = name;
        }
        return new GridExtent(names, null, high, false);
    }

    final GridGeometry getGridGeometry(Decoder decoder) throws IOException, DataStoreException {
        if (!this.isGeometryDetermined) {
            try {
                int i;
                this.isGeometryDetermined = true;
                Axis[] axes = this.getAxes(decoder);
                int lastSrcDim = this.getSourceDimensions();
                int lastTgtDim = this.getTargetDimensions();
                int[] deferred = new int[axes.length];
                ArrayList<MathTransform> nonLinears = new ArrayList<MathTransform>(axes.length);
                MatrixSIS affine = Matrices.createZero(lastTgtDim + 1, lastSrcDim + 1);
                affine.setElement(lastTgtDim--, lastSrcDim--, 1.0);
                for (int tgtDim = 0; tgtDim < axes.length; ++tgtDim) {
                    if (axes[tgtDim].trySetTransform(affine, lastSrcDim, tgtDim, nonLinears)) continue;
                    deferred[nonLinears.size() - 1] = tgtDim;
                }
                int[] sourceDimensions = new int[nonLinears.size()];
                Arrays.fill(sourceDimensions, -1);
                block7: for (i = 0; i < sourceDimensions.length; ++i) {
                    int tgtDim = deferred[i];
                    Axis axis = axes[tgtDim];
                    block8: for (int srcDim : axis.sourceDimensions) {
                        srcDim = lastSrcDim - srcDim;
                        int j = affine.getNumRow();
                        while (--j >= 0) {
                            if (affine.getElement(j, srcDim) == 0.0) continue;
                            continue block8;
                        }
                        sourceDimensions[i] = srcDim;
                        affine.setElement(tgtDim, srcDim, 1.0);
                        continue block7;
                    }
                }
                block10: for (i = 0; i < nonLinears.size(); ++i) {
                    if (nonLinears.get(i) != null) continue;
                    int j = i;
                    block11: while (++j < nonLinears.size()) {
                        MathTransform grid;
                        if (nonLinears.get(j) != null) continue;
                        Object[] gridAxes = new Axis[]{axes[deferred[i]], axes[deferred[j]]};
                        int srcDim = sourceDimensions[i];
                        int otherDim = sourceDimensions[j];
                        switch (srcDim - otherDim) {
                            case -1: {
                                break;
                            }
                            case 1: {
                                ArraysExt.swap(gridAxes, 0, 1);
                                break;
                            }
                            default: {
                                continue block11;
                            }
                        }
                        if ((grid = gridAxes[0].createLocalizationGrid((Axis)gridAxes[1])) == null) continue;
                        nonLinears.set(i, grid);
                        nonLinears.remove(j);
                        int n = nonLinears.size() - j;
                        System.arraycopy(deferred, j + 1, deferred, j, n);
                        System.arraycopy(sourceDimensions, j + 1, sourceDimensions, j, n);
                        if (otherDim >= srcDim) continue block10;
                        sourceDimensions[i] = otherDim;
                        continue block10;
                    }
                }
                MathTransform gridToCRS = null;
                int nonLinearCount = nonLinears.size();
                MathTransformFactory factory = decoder.getMathTransformFactory();
                nonLinears.add(factory.createAffineTransform((Matrix)affine));
                for (int i2 = 0; i2 <= nonLinearCount; ++i2) {
                    MathTransform tr = (MathTransform)nonLinears.get(i2);
                    if (tr == null) continue;
                    if (i2 < nonLinearCount) {
                        int srcDim = sourceDimensions[i2];
                        tr = factory.createPassThroughTransform(srcDim, tr, lastSrcDim + 1 - (srcDim + tr.getSourceDimensions()));
                    }
                    gridToCRS = gridToCRS == null ? tr : factory.createConcatenatedTransform(gridToCRS, tr);
                }
                CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem(decoder, null);
                if (CRS.getHorizontalComponent(crs) instanceof GeographicCRS) {
                    for (Axis axis : axes) {
                        if (!axis.isCellCorner()) continue;
                        this.anchor = PixelInCell.CELL_CORNER;
                        break;
                    }
                }
                this.geometry = new GridGeometry(this.getExtent(axes), this.anchor, gridToCRS, crs);
            }
            catch (IllegalGridGeometryException | FactoryException ex) {
                this.canNotCreate(decoder, "getGridGeometry", (short)12, (Exception)ex);
            }
        }
        return this.geometry;
    }

    final PixelInCell getAnchor() {
        return this.anchor;
    }

    private void canNotCreate(Decoder decoder, String caller, short key, Exception ex) {
        Grid.warning(decoder.listeners, Grid.class, caller, ex, null, key, decoder.getFilename(), this.getName(), ex.getLocalizedMessage());
    }
}

